/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Map;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.AbstractSearchScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.NativeScriptFactory;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.SearchLookup;

public class NativeScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    private final ImmutableMap<String, NativeScriptFactory> scripts;

    @Inject
    public NativeScriptEngineService(Settings settings, Map<String, NativeScriptFactory> scripts) {
        super(settings);
        this.scripts = ImmutableMap.copyOf(scripts);
    }

    @Override
    public String[] types() {
        return new String[]{"native"};
    }

    @Override
    public String[] extensions() {
        return new String[0];
    }

    @Override
    public Object compile(String script) {
        NativeScriptFactory scriptFactory = this.scripts.get(script);
        if (scriptFactory != null) {
            return scriptFactory;
        }
        throw new ElasticSearchIllegalArgumentException("Native script [" + script + "] not found");
    }

    @Override
    public ExecutableScript executable(Object compiledScript, @Nullable Map<String, Object> vars) {
        NativeScriptFactory scriptFactory = (NativeScriptFactory)compiledScript;
        return scriptFactory.newScript(vars);
    }

    @Override
    public SearchScript search(Object compiledScript, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        NativeScriptFactory scriptFactory = (NativeScriptFactory)compiledScript;
        AbstractSearchScript script = (AbstractSearchScript)scriptFactory.newScript(vars);
        script.setLookup(lookup);
        return script;
    }

    @Override
    public Object execute(Object compiledScript, Map<String, Object> vars) {
        return this.executable(compiledScript, vars).run();
    }

    @Override
    public Object unwrap(Object value2) {
        return value2;
    }

    @Override
    public void close() {
    }
}

