/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.deletebyquery;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequest;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.deletebyquery.IndexDeleteByQueryResponse;
import org.elasticsearch.action.deletebyquery.ShardDeleteByQueryRequest;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestDeleteByQueryAction
extends BaseRestHandler {
    @Inject
    public RestDeleteByQueryAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/_query", this);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/{type}/_query", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(RestActions.splitIndices(request.param("index")));
        deleteByQueryRequest.listenerThreaded(false);
        try {
            String consistencyLevel;
            if (request.hasContent()) {
                deleteByQueryRequest.query(request.content(), request.contentUnsafe());
            } else {
                String source2 = request.param("source");
                if (source2 != null) {
                    deleteByQueryRequest.query(source2);
                } else {
                    BytesReference bytes2 = RestActions.parseQuerySource(request);
                    deleteByQueryRequest.query(bytes2, false);
                }
            }
            deleteByQueryRequest.types(RestActions.splitTypes(request.param("type")));
            deleteByQueryRequest.timeout(request.paramAsTime("timeout", ShardDeleteByQueryRequest.DEFAULT_TIMEOUT));
            deleteByQueryRequest.routing(request.param("routing"));
            String replicationType = request.param("replication");
            if (replicationType != null) {
                deleteByQueryRequest.replicationType(ReplicationType.fromString(replicationType));
            }
            if ((consistencyLevel = request.param("consistency")) != null) {
                deleteByQueryRequest.consistencyLevel(WriteConsistencyLevel.fromString(consistencyLevel));
            }
        }
        catch (Exception e) {
            try {
                XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                channel.sendResponse(new XContentRestResponse(request, RestStatus.PRECONDITION_FAILED, builder.startObject().field("error", e.getMessage()).endObject()));
            }
            catch (IOException e1) {
                this.logger.error("Failed to send failure response", e1, new Object[0]);
            }
            return;
        }
        this.client.deleteByQuery(deleteByQueryRequest, new ActionListener<DeleteByQueryResponse>(){

            @Override
            public void onResponse(DeleteByQueryResponse result2) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject().field("ok", true);
                    builder.startObject("_indices");
                    for (IndexDeleteByQueryResponse indexDeleteByQueryResponse : result2.indices().values()) {
                        builder.startObject(indexDeleteByQueryResponse.index(), XContentBuilder.FieldCaseConversion.NONE);
                        builder.startObject("_shards");
                        builder.field("total", indexDeleteByQueryResponse.totalShards());
                        builder.field("successful", indexDeleteByQueryResponse.successfulShards());
                        builder.field("failed", indexDeleteByQueryResponse.failedShards());
                        builder.endObject();
                        builder.endObject();
                    }
                    builder.endObject();
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestDeleteByQueryAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

