/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.rest.AbstractRestResponse;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class Utf8RestResponse
extends AbstractRestResponse
implements RestResponse {
    public static final UnicodeUtil.UTF8Result EMPTY;
    private final RestStatus status;
    private final UnicodeUtil.UTF8Result utf8Result;
    private final UnicodeUtil.UTF8Result prefixUtf8Result;
    private final UnicodeUtil.UTF8Result suffixUtf8Result;

    public Utf8RestResponse(RestStatus status2) {
        this(status2, EMPTY);
    }

    public Utf8RestResponse(RestStatus status2, UnicodeUtil.UTF8Result utf8Result) {
        this(status2, utf8Result, null, null);
    }

    public Utf8RestResponse(RestStatus status2, UnicodeUtil.UTF8Result utf8Result, UnicodeUtil.UTF8Result prefixUtf8Result, UnicodeUtil.UTF8Result suffixUtf8Result) {
        this.status = status2;
        this.utf8Result = utf8Result;
        this.prefixUtf8Result = prefixUtf8Result;
        this.suffixUtf8Result = suffixUtf8Result;
    }

    @Override
    public boolean contentThreadSafe() {
        return false;
    }

    @Override
    public String contentType() {
        return "text/plain; charset=UTF-8";
    }

    @Override
    public byte[] content() {
        return this.utf8Result.result;
    }

    @Override
    public int contentLength() {
        return this.utf8Result.length;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    @Override
    public byte[] prefixContent() {
        return this.prefixUtf8Result != null ? this.prefixUtf8Result.result : null;
    }

    @Override
    public int prefixContentLength() {
        return this.prefixUtf8Result != null ? this.prefixUtf8Result.length : 0;
    }

    @Override
    public byte[] suffixContent() {
        return this.suffixUtf8Result != null ? this.suffixUtf8Result.result : null;
    }

    @Override
    public int suffixContentLength() {
        return this.suffixUtf8Result != null ? this.suffixUtf8Result.length : 0;
    }

    static {
        UnicodeUtil.UTF8Result temp = new UnicodeUtil.UTF8Result();
        temp.result = new byte[0];
        temp.length = 0;
        EMPTY = temp;
    }
}

