/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.network;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class NetworkStats
implements Streamable,
Serializable,
ToXContent {
    long timestamp;
    Tcp tcp = null;

    NetworkStats() {
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject(Fields.NETWORK);
        if (this.tcp != null) {
            builder.startObject(Fields.TCP);
            builder.field(Fields.ACTIVE_OPENS, this.tcp.getActiveOpens());
            builder.field(Fields.PASSIVE_OPENS, this.tcp.getPassiveOpens());
            builder.field(Fields.CURR_ESTAB, this.tcp.getCurrEstab());
            builder.field(Fields.IN_SEGS, this.tcp.getInSegs());
            builder.field(Fields.OUT_SEGS, this.tcp.getOutSegs());
            builder.field(Fields.RETRANS_SEGS, this.tcp.getRetransSegs());
            builder.field(Fields.ESTAB_RESETS, this.tcp.getEstabResets());
            builder.field(Fields.ATTEMPT_FAILS, this.tcp.getAttemptFails());
            builder.field(Fields.IN_ERRS, this.tcp.getInErrs());
            builder.field(Fields.OUT_RSTS, this.tcp.getOutRsts());
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static NetworkStats readNetworkStats(StreamInput in) throws IOException {
        NetworkStats stats = new NetworkStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        if (in.readBoolean()) {
            this.tcp = Tcp.readNetworkTcp(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        if (this.tcp == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.tcp.writeTo(out);
        }
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long getTimestamp() {
        return this.timestamp();
    }

    public Tcp tcp() {
        return this.tcp;
    }

    public Tcp getTcp() {
        return this.tcp();
    }

    public static class Tcp
    implements Serializable,
    Streamable {
        long activeOpens;
        long passiveOpens;
        long attemptFails;
        long estabResets;
        long currEstab;
        long inSegs;
        long outSegs;
        long retransSegs;
        long inErrs;
        long outRsts;

        public static Tcp readNetworkTcp(StreamInput in) throws IOException {
            Tcp tcp2 = new Tcp();
            tcp2.readFrom(in);
            return tcp2;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.activeOpens = in.readLong();
            this.passiveOpens = in.readLong();
            this.attemptFails = in.readLong();
            this.estabResets = in.readLong();
            this.currEstab = in.readLong();
            this.inSegs = in.readLong();
            this.outSegs = in.readLong();
            this.retransSegs = in.readLong();
            this.inErrs = in.readLong();
            this.outRsts = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.activeOpens);
            out.writeLong(this.passiveOpens);
            out.writeLong(this.attemptFails);
            out.writeLong(this.estabResets);
            out.writeLong(this.currEstab);
            out.writeLong(this.inSegs);
            out.writeLong(this.outSegs);
            out.writeLong(this.retransSegs);
            out.writeLong(this.inErrs);
            out.writeLong(this.outRsts);
        }

        public long activeOpens() {
            return this.activeOpens;
        }

        public long getActiveOpens() {
            return this.activeOpens();
        }

        public long passiveOpens() {
            return this.passiveOpens;
        }

        public long getPassiveOpens() {
            return this.passiveOpens();
        }

        public long attemptFails() {
            return this.attemptFails;
        }

        public long getAttemptFails() {
            return this.attemptFails();
        }

        public long estabResets() {
            return this.estabResets;
        }

        public long getEstabResets() {
            return this.estabResets();
        }

        public long currEstab() {
            return this.currEstab;
        }

        public long getCurrEstab() {
            return this.currEstab();
        }

        public long inSegs() {
            return this.inSegs;
        }

        public long getInSegs() {
            return this.inSegs();
        }

        public long outSegs() {
            return this.outSegs;
        }

        public long getOutSegs() {
            return this.outSegs();
        }

        public long retransSegs() {
            return this.retransSegs;
        }

        public long getRetransSegs() {
            return this.retransSegs();
        }

        public long inErrs() {
            return this.inErrs;
        }

        public long getInErrs() {
            return this.inErrs();
        }

        public long outRsts() {
            return this.outRsts;
        }

        public long getOutRsts() {
            return this.outRsts();
        }
    }

    static final class Fields {
        static final XContentBuilderString NETWORK = new XContentBuilderString("network");
        static final XContentBuilderString TCP = new XContentBuilderString("tcp");
        static final XContentBuilderString ACTIVE_OPENS = new XContentBuilderString("active_opens");
        static final XContentBuilderString PASSIVE_OPENS = new XContentBuilderString("passive_opens");
        static final XContentBuilderString CURR_ESTAB = new XContentBuilderString("curr_estab");
        static final XContentBuilderString IN_SEGS = new XContentBuilderString("in_segs");
        static final XContentBuilderString OUT_SEGS = new XContentBuilderString("out_segs");
        static final XContentBuilderString RETRANS_SEGS = new XContentBuilderString("retrans_segs");
        static final XContentBuilderString ESTAB_RESETS = new XContentBuilderString("estab_resets");
        static final XContentBuilderString ATTEMPT_FAILS = new XContentBuilderString("attempt_fails");
        static final XContentBuilderString IN_ERRS = new XContentBuilderString("in_errs");
        static final XContentBuilderString OUT_RSTS = new XContentBuilderString("out_rsts");

        Fields() {
        }
    }
}

