/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.dump.heap;

import java.lang.reflect.Method;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.monitor.dump.Dump;
import org.elasticsearch.monitor.dump.DumpContributionFailedException;
import org.elasticsearch.monitor.dump.DumpContributor;

public class HeapDumpContributor
implements DumpContributor {
    public static final String HEAP_DUMP = "heap";
    private final Method heapDumpMethod;
    private final Object diagnosticMBean;
    private final String name;

    @Inject
    public HeapDumpContributor(@Assisted String name2, @Assisted Settings settings) {
        Method heapDumpMethod;
        Object diagnosticMBean;
        this.name = name2;
        try {
            Class<?> managementFactoryClass = Class.forName("sun.management.ManagementFactory", true, HeapDumpContributor.class.getClassLoader());
            Method method2 = managementFactoryClass.getMethod("getDiagnosticMXBean", new Class[0]);
            diagnosticMBean = method2.invoke(null, new Object[0]);
            heapDumpMethod = diagnosticMBean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
        }
        catch (Exception _ex) {
            heapDumpMethod = null;
            diagnosticMBean = null;
        }
        this.heapDumpMethod = heapDumpMethod;
        this.diagnosticMBean = diagnosticMBean;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void contribute(Dump dump2) throws DumpContributionFailedException {
        if (this.heapDumpMethod == null) {
            throw new DumpContributionFailedException(this.getName(), "Heap dump not enalbed on this JVM");
        }
        try {
            this.heapDumpMethod.invoke(this.diagnosticMBean, dump2.createFile("heap.hprof").getAbsolutePath(), true);
        }
        catch (Exception e) {
            throw new DumpContributionFailedException(this.getName(), "Failed to generate heap dump", e);
        }
    }
}

