/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.transport.TransportRequest;

class RecoveryTranslogOperationsRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    private List<Translog.Operation> operations;

    RecoveryTranslogOperationsRequest() {
    }

    RecoveryTranslogOperationsRequest(long recoveryId, ShardId shardId, List<Translog.Operation> operations) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.operations = operations;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public List<Translog.Operation> operations() {
        return this.operations;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = ShardId.readShardId(in);
        int size2 = in.readVInt();
        this.operations = Lists.newArrayListWithExpectedSize(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            this.operations.add(TranslogStreams.readTranslogOperation(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeVInt(this.operations.size());
        for (Translog.Operation operation : this.operations) {
            TranslogStreams.writeTranslogOperation(out, operation);
        }
    }
}

