/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog.fs;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.jsr166y.ThreadLocalRandom;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.index.translog.fs.FsChannelSnapshot;
import org.elasticsearch.index.translog.fs.FsTranslogFile;
import org.elasticsearch.index.translog.fs.RafReference;

public class FsTranslog
extends AbstractIndexShardComponent
implements Translog {
    public static final String INDEX_TRANSLOG_FS_TYPE = "index.translog.fs.type";
    public static final String INDEX_TRANSLOG_FS_BUFFER_SIZE = "index.translog.fs.buffer_size";
    public static final String INDEX_TRANSLOG_FS_TRANSIENT_BUFFER_SIZE = "index.translog.fs.transient_buffer_size";
    private final IndexSettingsService indexSettingsService;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private final File[] locations;
    private volatile FsTranslogFile current;
    private volatile FsTranslogFile trans;
    private FsTranslogFile.Type type;
    private boolean syncOnEachOperation = false;
    private int bufferSize;
    private int transientBufferSize;
    private final ApplySettings applySettings = new ApplySettings();

    @Inject
    public FsTranslog(ShardId shardId, @IndexSettings Settings indexSettings, IndexSettingsService indexSettingsService, NodeEnvironment nodeEnv) {
        super(shardId, indexSettings);
        this.indexSettingsService = indexSettingsService;
        File[] shardLocations = nodeEnv.shardLocations(shardId);
        this.locations = new File[shardLocations.length];
        for (int i2 = 0; i2 < shardLocations.length; ++i2) {
            this.locations[i2] = new File(shardLocations[i2], "translog");
            FileSystemUtils.mkdirs(this.locations[i2]);
        }
        this.type = FsTranslogFile.Type.fromString(this.componentSettings.get("type", FsTranslogFile.Type.BUFFERED.name()));
        this.bufferSize = (int)this.componentSettings.getAsBytesSize("buffer_size", ByteSizeValue.parseBytesSizeValue("64k")).bytes();
        this.transientBufferSize = (int)this.componentSettings.getAsBytesSize("transient_buffer_size", ByteSizeValue.parseBytesSizeValue("8k")).bytes();
        indexSettingsService.addListener(this.applySettings);
    }

    public FsTranslog(ShardId shardId, @IndexSettings Settings indexSettings, File location) {
        super(shardId, indexSettings);
        this.indexSettingsService = null;
        this.locations = new File[]{location};
        FileSystemUtils.mkdirs(location);
        this.type = FsTranslogFile.Type.fromString(this.componentSettings.get("type", FsTranslogFile.Type.BUFFERED.name()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean delete2) {
        if (this.indexSettingsService != null) {
            this.indexSettingsService.removeListener(this.applySettings);
        }
        this.rwl.writeLock().lock();
        try {
            FsTranslogFile current1 = this.current;
            if (current1 != null) {
                current1.close(delete2);
            }
            if ((current1 = this.trans) != null) {
                current1.close(delete2);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public File[] locations() {
        return this.locations;
    }

    @Override
    public long currentId() {
        FsTranslogFile current1 = this.current;
        if (current1 == null) {
            return -1L;
        }
        return current1.id();
    }

    @Override
    public int estimatedNumberOfOperations() {
        FsTranslogFile current1 = this.current;
        if (current1 == null) {
            return 0;
        }
        return current1.estimatedNumberOfOperations();
    }

    @Override
    public long memorySizeInBytes() {
        return 0L;
    }

    @Override
    public long translogSizeInBytes() {
        FsTranslogFile current1 = this.current;
        if (current1 == null) {
            return 0L;
        }
        return current1.translogSizeInBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearUnreferenced() {
        this.rwl.writeLock().lock();
        try {
            for (File location : this.locations) {
                File[] files = location.listFiles();
                if (files == null) continue;
                for (File file2 : files) {
                    if (file2.getName().equals("translog-" + this.current.id()) || this.trans != null && file2.getName().equals("translog-" + this.trans.id())) continue;
                    try {
                        file2.delete();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newTranslog(long id2) throws TranslogException {
        this.rwl.writeLock().lock();
        try {
            FsTranslogFile newFile;
            long size2 = Long.MAX_VALUE;
            File location = null;
            for (File file2 : this.locations) {
                long currentFree = file2.getFreeSpace();
                if (currentFree < size2) {
                    size2 = currentFree;
                    location = file2;
                    continue;
                }
                if (currentFree != size2 || !ThreadLocalRandom.current().nextBoolean()) continue;
                location = file2;
            }
            try {
                newFile = this.type.create(this.shardId, id2, new RafReference(new File(location, "translog-" + id2)), this.bufferSize);
            }
            catch (IOException e) {
                throw new TranslogException(this.shardId, "failed to create new translog file", (Throwable)e);
            }
            FsTranslogFile old = this.current;
            this.current = newFile;
            if (old != null) {
                boolean delete2 = true;
                if (old.id() == id2) {
                    delete2 = false;
                }
                old.close(delete2);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public void newTransientTranslog(long id2) throws TranslogException {
        this.rwl.writeLock().lock();
        try {
            assert (this.trans == null);
            long size2 = Long.MAX_VALUE;
            File location = null;
            for (File file2 : this.locations) {
                long currentFree = file2.getFreeSpace();
                if (currentFree < size2) {
                    size2 = currentFree;
                    location = file2;
                    continue;
                }
                if (currentFree != size2 || !ThreadLocalRandom.current().nextBoolean()) continue;
                location = file2;
            }
            this.trans = this.type.create(this.shardId, id2, new RafReference(new File(location, "translog-" + id2)), this.transientBufferSize);
        }
        catch (IOException e) {
            throw new TranslogException(this.shardId, "failed to create new translog file", (Throwable)e);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeTransientCurrent() {
        FsTranslogFile old;
        this.rwl.writeLock().lock();
        try {
            assert (this.trans != null);
            old = this.current;
            this.current = this.trans;
            this.trans = null;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        old.close(true);
        this.current.reuse(old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revertTransient() {
        FsTranslogFile old;
        this.rwl.writeLock().lock();
        try {
            old = this.trans;
            this.trans = null;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        old.close(true);
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] read(Translog.Location location) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Translog.Location add(Translog.Operation operation) throws TranslogException {
        CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
        this.rwl.readLock().lock();
        try {
            FsTranslogFile trans;
            BytesStreamOutput out = cachedEntry.bytes();
            out.writeInt(0);
            TranslogStreams.writeTranslogOperation(out, operation);
            out.flush();
            int size2 = out.size();
            out.seek(0);
            out.writeInt(size2 - 4);
            Translog.Location location = this.current.add(out.bytes().array(), out.bytes().arrayOffset(), size2);
            if (this.syncOnEachOperation) {
                this.current.sync();
            }
            if ((trans = this.trans) != null) {
                try {
                    location = trans.add(out.bytes().array(), out.bytes().arrayOffset(), size2);
                }
                catch (ClosedChannelException e) {
                    // empty catch block
                }
            }
            Translog.Location location2 = location;
            return location2;
        }
        catch (Exception e) {
            throw new TranslogException(this.shardId, "Failed to write operation [" + operation + "]", (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
            CachedStreamOutput.pushEntry(cachedEntry);
        }
    }

    @Override
    public FsChannelSnapshot snapshot() throws TranslogException {
        FsChannelSnapshot snapshot;
        while ((snapshot = this.current.snapshot()) == null) {
            Thread.yield();
        }
        return snapshot;
    }

    @Override
    public Translog.Snapshot snapshot(Translog.Snapshot snapshot) {
        FsChannelSnapshot snap = this.snapshot();
        if (snap.translogId() == snapshot.translogId()) {
            snap.seekForward(snapshot.position());
        }
        return snap;
    }

    @Override
    public void sync() {
        FsTranslogFile current1 = this.current;
        if (current1 == null) {
            return;
        }
        current1.sync();
    }

    @Override
    public boolean syncNeeded() {
        FsTranslogFile current1 = this.current;
        return current1 != null && current1.syncNeeded();
    }

    @Override
    public void syncOnEachOperation(boolean syncOnEachOperation) {
        this.syncOnEachOperation = syncOnEachOperation;
        this.type = syncOnEachOperation ? FsTranslogFile.Type.SIMPLE : FsTranslogFile.Type.BUFFERED;
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            FsTranslogFile.Type type2;
            int transientBufferSize;
            int bufferSize = (int)settings.getAsBytesSize(FsTranslog.INDEX_TRANSLOG_FS_BUFFER_SIZE, new ByteSizeValue(FsTranslog.this.bufferSize)).bytes();
            if (bufferSize != FsTranslog.this.bufferSize) {
                FsTranslog.this.logger.info("updating buffer_size from [{}] to [{}]", new ByteSizeValue(FsTranslog.this.bufferSize), new ByteSizeValue(bufferSize));
                FsTranslog.this.bufferSize = bufferSize;
            }
            if ((transientBufferSize = (int)settings.getAsBytesSize(FsTranslog.INDEX_TRANSLOG_FS_TRANSIENT_BUFFER_SIZE, new ByteSizeValue(FsTranslog.this.transientBufferSize)).bytes()) != FsTranslog.this.transientBufferSize) {
                FsTranslog.this.logger.info("updating transient_buffer_size from [{}] to [{}]", new ByteSizeValue(FsTranslog.this.transientBufferSize), new ByteSizeValue(transientBufferSize));
                FsTranslog.this.transientBufferSize = transientBufferSize;
            }
            if ((type2 = FsTranslogFile.Type.fromString(settings.get(FsTranslog.INDEX_TRANSLOG_FS_TYPE, FsTranslog.this.type.name()))) != FsTranslog.this.type) {
                FsTranslog.this.logger.info("updating type from [{}] to [{}]", new Object[]{FsTranslog.this.type, type2});
                FsTranslog.this.type = type2;
            }
        }
    }
}

