/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.fs;

import java.io.File;
import java.io.IOException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.support.AbstractIndexStore;
import org.elasticsearch.indices.store.IndicesStore;

public abstract class FsIndexStore
extends AbstractIndexStore {
    private final NodeEnvironment nodeEnv;
    private final File[] locations;

    public FsIndexStore(Index index2, @IndexSettings Settings indexSettings, IndexService indexService, IndicesStore indicesStore, NodeEnvironment nodeEnv) {
        super(index2, indexSettings, indexService, indicesStore);
        this.nodeEnv = nodeEnv;
        this.locations = nodeEnv.hasNodeFile() ? nodeEnv.indexLocations(index2) : null;
    }

    @Override
    public boolean persistent() {
        return true;
    }

    @Override
    public ByteSizeValue backingStoreTotalSpace() {
        if (this.locations == null) {
            return new ByteSizeValue(0L);
        }
        long totalSpace = 0L;
        for (File location : this.locations) {
            totalSpace += location.getTotalSpace();
        }
        return new ByteSizeValue(totalSpace);
    }

    @Override
    public ByteSizeValue backingStoreFreeSpace() {
        if (this.locations == null) {
            return new ByteSizeValue(0L);
        }
        long usableSpace = 0L;
        for (File location : this.locations) {
            usableSpace += location.getUsableSpace();
        }
        return new ByteSizeValue(usableSpace);
    }

    @Override
    public boolean canDeleteUnallocated(ShardId shardId) {
        if (this.locations == null) {
            return false;
        }
        if (this.indexService.hasShard(shardId.id())) {
            return false;
        }
        for (File location : this.shardLocations(shardId)) {
            if (!location.exists()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deleteUnallocated(ShardId shardId) throws IOException {
        if (this.locations == null) {
            return;
        }
        if (this.indexService.hasShard(shardId.id())) {
            throw new ElasticSearchIllegalStateException(shardId + " allocated, can't be deleted");
        }
        FileSystemUtils.deleteRecursively(this.shardLocations(shardId));
    }

    public File[] shardLocations(ShardId shardId) {
        return this.nodeEnv.shardLocations(shardId);
    }

    public File[] shardIndexLocations(ShardId shardId) {
        File[] shardLocations = this.shardLocations(shardId);
        File[] shardIndexLocations = new File[shardLocations.length];
        for (int i2 = 0; i2 < shardLocations.length; ++i2) {
            shardIndexLocations[i2] = new File(shardLocations[i2], "index");
        }
        return shardIndexLocations;
    }

    public File[] shardTranslogLocations(ShardId shardId) {
        File[] shardLocations = this.shardLocations(shardId);
        File[] shardTranslogLocations = new File[shardLocations.length];
        for (int i2 = 0; i2 < shardLocations.length; ++i2) {
            shardTranslogLocations[i2] = new File(shardLocations[i2], "translog");
        }
        return shardTranslogLocations;
    }
}

