/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.settings;

import org.elasticsearch.cluster.settings.DynamicSettings;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.index.settings.IndexDynamicSettings;

public class IndexDynamicSettingsModule
extends AbstractModule {
    private final DynamicSettings indexDynamicSettings = new DynamicSettings();

    public IndexDynamicSettingsModule() {
        this.indexDynamicSettings.addDynamicSettings("index.store.throttle.max_bytes_per_sec", "index.store.throttle.type", "index.routing.allocation.require.*", "index.routing.allocation.include.*", "index.routing.allocation.exclude.*", "index.translog.fs.type", "index.translog.fs.buffer_size", "index.translog.fs.transient_buffer_size", "index.number_of_replicas", "index.auto_expand_replicas", "index.blocks.read_only", "index.blocks.read", "index.blocks.write", "index.blocks.metadata", "index.gateway.snapshot_interval", "index.ttl.disable_purge", "index.refresh_interval", "index.recovery.initial_shards", "index.merge.policy.min_merge_size", "index.merge.policy.max_merge_size", "index.merge.policy.max_merge_docs", "index.merge.policy.merge_factor", "index.compound_format", "index.merge.policy.min_merge_docs", "index.merge.policy.max_merge_docs", "index.merge.policy.merge_factor", "index.compound_format", "index.cache.field.max_size", "index.cache.field.expire", "index.term_index_interval", "index.term_index_divisor", "index.index_concurrency", "index.gc_deletes", "index.indexing.slowlog.threshold.index.warn", "index.indexing.slowlog.threshold.index.info", "index.indexing.slowlog.threshold.index.debug", "index.indexing.slowlog.threshold.index.trace", "index.indexing.slowlog.reformat", "index.indexing.slowlog.level", "index.search.slowlog.threshold.query.warn", "index.search.slowlog.threshold.query.info", "index.search.slowlog.threshold.query.debug", "index.search.slowlog.threshold.query.trace", "index.search.slowlog.threshold.fetch.warn", "index.search.slowlog.threshold.fetch.info", "index.search.slowlog.threshold.fetch.debug", "index.search.slowlog.threshold.fetch.trace", "index.search.slowlog.reformat", "index.search.slowlog.level", "index.routing.allocation.total_shards_per_node", "index.store.compress.stored", "index.store.compress.tv", "index.merge.policy.expunge_deletes_allowed", "index.merge.policy.floor_segment", "index.merge.policy.max_merge_at_once", "index.merge.policy.max_merge_at_once_explicit", "index.merge.policy.max_merged_segment", "index.merge.policy.segments_per_tier", "index.merge.policy.reclaim_deletes_weight", "index.compound_format", "index.translog.flush_threshold_ops", "index.translog.flush_threshold_size", "index.translog.flush_threshold_period", "index.translog.disable_flush");
    }

    public void addDynamicSetting(String ... settings) {
        this.indexDynamicSettings.addDynamicSettings(settings);
    }

    @Override
    protected void configure() {
        this.bind(DynamicSettings.class).annotatedWith(IndexDynamicSettings.class).toInstance(this.indexDynamicSettings);
    }
}

