/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.lucene.docset.GetDocSet;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.mapper.geo.GeoPointFieldData;
import org.elasticsearch.index.mapper.geo.GeoPointFieldDataType;
import org.elasticsearch.index.search.geo.Point;

public class GeoPolygonFilter
extends Filter {
    private final Point[] points;
    private final String fieldName;
    private final FieldDataCache fieldDataCache;

    public GeoPolygonFilter(Point[] points, String fieldName, FieldDataCache fieldDataCache) {
        this.points = points;
        this.fieldName = fieldName;
        this.fieldDataCache = fieldDataCache;
    }

    public Point[] points() {
        return this.points;
    }

    public String fieldName() {
        return this.fieldName;
    }

    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        GeoPointFieldData fieldData = (GeoPointFieldData)this.fieldDataCache.cache(GeoPointFieldDataType.TYPE, reader, this.fieldName);
        return new GeoPolygonDocSet(reader.maxDoc(), fieldData, this.points);
    }

    public String toString() {
        return "GeoPolygonFilter(" + this.fieldName + ", " + Arrays.toString(this.points) + ")";
    }

    public static class GeoPolygonDocSet
    extends GetDocSet {
        private final GeoPointFieldData fieldData;
        private final Point[] points;

        public GeoPolygonDocSet(int maxDoc, GeoPointFieldData fieldData, Point[] points) {
            super(maxDoc);
            this.fieldData = fieldData;
            this.points = points;
        }

        @Override
        public boolean isCacheable() {
            return false;
        }

        @Override
        public boolean get(int doc) {
            if (!this.fieldData.hasValue(doc)) {
                return false;
            }
            if (this.fieldData.multiValued()) {
                double[] lats = this.fieldData.latValues(doc);
                double[] lons = this.fieldData.lonValues(doc);
                for (int i2 = 0; i2 < lats.length; ++i2) {
                    if (!GeoPolygonDocSet.pointInPolygon(this.points, lats[i2], lons[i2])) continue;
                    return true;
                }
            } else {
                double lat = this.fieldData.latValue(doc);
                double lon = this.fieldData.lonValue(doc);
                return GeoPolygonDocSet.pointInPolygon(this.points, lat, lon);
            }
            return false;
        }

        private static boolean pointInPolygon(Point[] points, double lat, double lon) {
            int j = points.length - 1;
            boolean inPoly = false;
            int i2 = 0;
            while (i2 < points.length) {
                if ((points[i2].lon < lon && points[j].lon >= lon || points[j].lon < lon && points[i2].lon >= lon) && points[i2].lat + (lon - points[i2].lon) / (points[j].lon - points[i2].lon) * (points[j].lat - points[i2].lat) < lat) {
                    inPoly = !inPoly;
                }
                j = i2++;
            }
            return inPoly;
        }
    }
}

