/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import org.elasticsearch.common.trove.map.hash.TIntIntHashMap;

public class GeoHashUtils {
    private static final char[] BASE_32 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final TIntIntHashMap DECODE_MAP = new TIntIntHashMap();
    public static final int PRECISION = 12;
    private static final int[] BITS = new int[]{16, 8, 4, 2, 1};

    private GeoHashUtils() {
    }

    public static String encode(double latitude, double longitude) {
        return GeoHashUtils.encode(latitude, longitude, 12);
    }

    public static String encode(double latitude, double longitude, int precision) {
        double latInterval0 = -90.0;
        double latInterval1 = 90.0;
        double lngInterval0 = -180.0;
        double lngInterval1 = 180.0;
        StringBuilder geohash = new StringBuilder();
        boolean isEven = true;
        int bit = 0;
        int ch = 0;
        while (geohash.length() < precision) {
            double mid = 0.0;
            if (isEven) {
                mid = (lngInterval0 + lngInterval1) / 2.0;
                if (longitude > mid) {
                    ch |= BITS[bit];
                    lngInterval0 = mid;
                } else {
                    lngInterval1 = mid;
                }
            } else {
                mid = (latInterval0 + latInterval1) / 2.0;
                if (latitude > mid) {
                    ch |= BITS[bit];
                    latInterval0 = mid;
                } else {
                    latInterval1 = mid;
                }
            }
            boolean bl = isEven = !isEven;
            if (bit < 4) {
                ++bit;
                continue;
            }
            geohash.append(BASE_32[ch]);
            bit = 0;
            ch = 0;
        }
        return geohash.toString();
    }

    public static double[] decode(String geohash) {
        double[] ret = new double[2];
        GeoHashUtils.decode(geohash, ret);
        return ret;
    }

    public static void decode(String geohash, double[] ret) {
        double latInterval0 = -90.0;
        double latInterval1 = 90.0;
        double lngInterval0 = -180.0;
        double lngInterval1 = 180.0;
        boolean isEven = true;
        for (int i2 = 0; i2 < geohash.length(); ++i2) {
            int cd = DECODE_MAP.get(geohash.charAt(i2));
            for (int mask : BITS) {
                if (isEven) {
                    if ((cd & mask) != 0) {
                        lngInterval0 = (lngInterval0 + lngInterval1) / 2.0;
                    } else {
                        lngInterval1 = (lngInterval0 + lngInterval1) / 2.0;
                    }
                } else if ((cd & mask) != 0) {
                    latInterval0 = (latInterval0 + latInterval1) / 2.0;
                } else {
                    latInterval1 = (latInterval0 + latInterval1) / 2.0;
                }
                isEven = !isEven;
            }
        }
        ret[0] = (latInterval0 + latInterval1) / 2.0;
        ret[1] = (lngInterval0 + lngInterval1) / 2.0;
    }

    static {
        for (int i2 = 0; i2 < BASE_32.length; ++i2) {
            DECODE_MAP.put(BASE_32[i2], i2);
        }
    }
}

