/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.lucene.search.EmptyScorer;
import org.elasticsearch.common.trove.map.hash.TIntObjectHashMap;
import org.elasticsearch.index.search.child.ScoreType;
import org.elasticsearch.search.internal.ScopePhase;
import org.elasticsearch.search.internal.SearchContext;

public class TopChildrenQuery
extends Query
implements ScopePhase.TopDocsPhase {
    private Query query;
    private String scope;
    private String parentType;
    private String childType;
    private ScoreType scoreType;
    private int factor;
    private int incrementalFactor;
    private Map<Object, ParentDoc[]> parentDocs;
    private int numHits = 0;
    private boolean[] properlyInvoked = new boolean[]{false};
    private static final ParentDocComparator PARENT_DOC_COMP = new ParentDocComparator();

    public TopChildrenQuery(Query query, String scope, String childType, String parentType, ScoreType scoreType, int factor, int incrementalFactor) {
        this.query = query;
        this.scope = scope;
        this.childType = childType;
        this.parentType = parentType;
        this.scoreType = scoreType;
        this.factor = factor;
        this.incrementalFactor = incrementalFactor;
    }

    @Override
    public Query query() {
        return this;
    }

    @Override
    public String scope() {
        return this.scope;
    }

    @Override
    public void clear() {
        this.properlyInvoked[0] = true;
        this.parentDocs = null;
        this.numHits = 0;
    }

    @Override
    public int numHits() {
        return this.numHits;
    }

    @Override
    public int factor() {
        return this.factor;
    }

    @Override
    public int incrementalFactor() {
        return this.incrementalFactor;
    }

    @Override
    public void processResults(TopDocs topDocs, SearchContext context) {
        HashMap parentDocsPerReader = new HashMap();
        for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
            int readerIndex = context.searcher().readerIndex(scoreDoc.doc);
            IndexReader subReader = context.searcher().subReaders()[readerIndex];
            int subDoc = scoreDoc.doc - context.searcher().docStarts()[readerIndex];
            HashedBytesArray parentId = context.idCache().reader(subReader).parentIdByDoc(this.parentType, subDoc);
            if (parentId == null) continue;
            for (IndexReader indexReader : context.searcher().subReaders()) {
                ParentDoc parentDoc;
                int parentDocId = context.idCache().reader(indexReader).docById(this.parentType, parentId);
                if (parentDocId == -1 || indexReader.isDeleted(parentDocId)) continue;
                TIntObjectHashMap<ParentDoc> readerParentDocs = (TIntObjectHashMap<ParentDoc>)parentDocsPerReader.get(indexReader.getCoreCacheKey());
                if (readerParentDocs == null) {
                    readerParentDocs = new TIntObjectHashMap<ParentDoc>();
                    parentDocsPerReader.put(indexReader.getCoreCacheKey(), readerParentDocs);
                }
                if ((parentDoc = (ParentDoc)readerParentDocs.get(parentDocId)) == null) {
                    ++this.numHits;
                    parentDoc = new ParentDoc();
                    parentDoc.docId = parentDocId;
                    parentDoc.count = 1;
                    parentDoc.maxScore = scoreDoc.score;
                    parentDoc.sumScores = scoreDoc.score;
                    readerParentDocs.put(parentDocId, parentDoc);
                    continue;
                }
                ++parentDoc.count;
                parentDoc.sumScores += scoreDoc.score;
                if (!(scoreDoc.score > parentDoc.maxScore)) continue;
                parentDoc.maxScore = scoreDoc.score;
            }
        }
        this.parentDocs = new HashMap<Object, ParentDoc[]>();
        for (Map.Entry entry : parentDocsPerReader.entrySet()) {
            ParentDoc[] values2 = ((TIntObjectHashMap)entry.getValue()).values(new ParentDoc[((TIntObjectHashMap)entry.getValue()).size()]);
            Arrays.sort(values2, PARENT_DOC_COMP);
            this.parentDocs.put(entry.getKey(), values2);
        }
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query newQ = this.query.rewrite(reader);
        if (newQ == this.query) {
            return this;
        }
        TopChildrenQuery bq = (TopChildrenQuery)this.clone();
        bq.query = newQ;
        return bq;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.query.extractTerms(terms);
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        if (!this.properlyInvoked[0]) {
            throw new ElasticSearchIllegalStateException("top_children query hasn't executed properly");
        }
        if (this.parentDocs != null) {
            return new ParentWeight(searcher, this.query.weight(searcher));
        }
        return this.query.weight(searcher);
    }

    @Override
    public String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        sb.append("score_child[").append(this.childType).append("/").append(this.parentType).append("](").append(this.query.toString(field2)).append(')');
        sb.append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }

    class ParentScorer
    extends Scorer {
        private final ParentDoc[] docs;
        private int index;

        private ParentScorer(Similarity similarity, ParentDoc[] docs) throws IOException {
            super(similarity);
            this.index = -1;
            this.docs = docs;
        }

        @Override
        public int docID() {
            if (this.index == -1) {
                return -1;
            }
            if (this.index >= this.docs.length) {
                return Integer.MAX_VALUE;
            }
            return this.docs[this.index].docId;
        }

        @Override
        public int advance(int target) throws IOException {
            int doc;
            while ((doc = this.nextDoc()) < target) {
            }
            return doc;
        }

        @Override
        public int nextDoc() throws IOException {
            if (++this.index >= this.docs.length) {
                return Integer.MAX_VALUE;
            }
            return this.docs[this.index].docId;
        }

        @Override
        public float score() throws IOException {
            if (TopChildrenQuery.this.scoreType == ScoreType.MAX) {
                return this.docs[this.index].maxScore;
            }
            if (TopChildrenQuery.this.scoreType == ScoreType.AVG) {
                return this.docs[this.index].sumScores / (float)this.docs[this.index].count;
            }
            if (TopChildrenQuery.this.scoreType == ScoreType.SUM) {
                return this.docs[this.index].sumScores;
            }
            throw new ElasticSearchIllegalStateException("No support for score type [" + (Object)((Object)TopChildrenQuery.this.scoreType) + "]");
        }
    }

    class ParentWeight
    extends Weight {
        final Searcher searcher;
        final Weight queryWeight;

        public ParentWeight(Searcher searcher, Weight queryWeight) throws IOException {
            this.searcher = searcher;
            this.queryWeight = queryWeight;
        }

        @Override
        public Query getQuery() {
            return TopChildrenQuery.this;
        }

        @Override
        public float getValue() {
            return TopChildrenQuery.this.getBoost();
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            float sum2 = this.queryWeight.sumOfSquaredWeights();
            return sum2 *= TopChildrenQuery.this.getBoost() * TopChildrenQuery.this.getBoost();
        }

        @Override
        public void normalize(float norm) {
        }

        @Override
        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            ParentDoc[] readerParentDocs = (ParentDoc[])TopChildrenQuery.this.parentDocs.get(reader.getCoreCacheKey());
            if (readerParentDocs != null) {
                return new ParentScorer(TopChildrenQuery.this.getSimilarity(this.searcher), readerParentDocs);
            }
            return new EmptyScorer(TopChildrenQuery.this.getSimilarity(this.searcher));
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation(TopChildrenQuery.this.getBoost(), "not implemented yet...");
        }
    }

    public static class ParentDoc {
        public int docId;
        public int count;
        public float maxScore = Float.NaN;
        public float sumScores = 0.0f;
    }

    static class ParentDocComparator
    implements Comparator<ParentDoc> {
        ParentDocComparator() {
        }

        @Override
        public int compare(ParentDoc o1, ParentDoc o2) {
            return o1.docId - o2.docId;
        }
    }
}

