/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.queryParser.MapperQueryParser;
import org.apache.lucene.queryParser.QueryParserSettings;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.engine.IndexEngine;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SearchLookup;

public class QueryParseContext {
    private static ThreadLocal<String[]> typesContext = new ThreadLocal();
    private final Index index;
    IndexQueryParserService indexQueryParser;
    private final Map<String, Filter> namedFilters = Maps.newHashMap();
    private final MapperQueryParser queryParser = new MapperQueryParser(this);
    private XContentParser parser;
    private SearchLookup lookup = null;

    public static void setTypes(String[] types) {
        typesContext.set(types);
    }

    public static String[] getTypes() {
        return typesContext.get();
    }

    public static String[] setTypesWithPrevious(String[] types) {
        String[] old = typesContext.get();
        QueryParseContext.setTypes(types);
        return old;
    }

    public static void removeTypes() {
        typesContext.remove();
    }

    public QueryParseContext(Index index2, IndexQueryParserService indexQueryParser) {
        this.index = index2;
        this.indexQueryParser = indexQueryParser;
    }

    public void reset(XContentParser jp) {
        this.lookup = null;
        this.parser = jp;
        this.namedFilters.clear();
    }

    public Index index() {
        return this.index;
    }

    public XContentParser parser() {
        return this.parser;
    }

    public AnalysisService analysisService() {
        return this.indexQueryParser.analysisService;
    }

    public ScriptService scriptService() {
        return this.indexQueryParser.scriptService;
    }

    public MapperService mapperService() {
        return this.indexQueryParser.mapperService;
    }

    public IndexEngine indexEngine() {
        return this.indexQueryParser.indexEngine;
    }

    @Nullable
    public SimilarityService similarityService() {
        return this.indexQueryParser.similarityService;
    }

    public Similarity searchSimilarity() {
        return this.indexQueryParser.similarityService != null ? this.indexQueryParser.similarityService.defaultSearchSimilarity() : null;
    }

    public IndexCache indexCache() {
        return this.indexQueryParser.indexCache;
    }

    public String defaultField() {
        return this.indexQueryParser.defaultField();
    }

    public boolean queryStringLenient() {
        return this.indexQueryParser.queryStringLenient();
    }

    public MapperQueryParser queryParser(QueryParserSettings settings) {
        this.queryParser.reset(settings);
        return this.queryParser;
    }

    public Filter cacheFilter(Filter filter, @Nullable CacheKeyFilter.Key cacheKey) {
        if (cacheKey != null) {
            filter = new CacheKeyFilter.Wrapper(filter, cacheKey);
        }
        return this.indexQueryParser.indexCache.filter().cache(filter);
    }

    public void addNamedFilter(String name2, Filter filter) {
        this.namedFilters.put(name2, filter);
    }

    public ImmutableMap<String, Filter> copyNamedFilters() {
        if (this.namedFilters.isEmpty()) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf(this.namedFilters);
    }

    @Nullable
    public Query parseInnerQuery() throws IOException, QueryParsingException {
        XContentParser.Token token;
        if (this.parser.currentToken() != XContentParser.Token.START_OBJECT && (token = this.parser.nextToken()) != XContentParser.Token.START_OBJECT) {
            throw new QueryParsingException(this.index, "[_na] query malformed, must start with start_object");
        }
        token = this.parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(this.index, "[_na] query malformed, no field after start_object");
        }
        String queryName = this.parser.currentName();
        token = this.parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT && token != XContentParser.Token.START_ARRAY) {
            throw new QueryParsingException(this.index, "[_na] query malformed, no field after start_object");
        }
        QueryParser queryParser = this.indexQueryParser.queryParser(queryName);
        if (queryParser == null) {
            throw new QueryParsingException(this.index, "No query registered for [" + queryName + "]");
        }
        Query result2 = queryParser.parse(this);
        if (this.parser.currentToken() == XContentParser.Token.END_OBJECT || this.parser.currentToken() == XContentParser.Token.END_ARRAY) {
            this.parser.nextToken();
        }
        return result2;
    }

    @Nullable
    public Filter parseInnerFilter() throws IOException, QueryParsingException {
        XContentParser.Token token;
        if (this.parser.currentToken() != XContentParser.Token.START_OBJECT && (token = this.parser.nextToken()) != XContentParser.Token.START_OBJECT) {
            throw new QueryParsingException(this.index, "[_na] filter malformed, must start with start_object");
        }
        token = this.parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            if (token == XContentParser.Token.END_OBJECT || token == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            throw new QueryParsingException(this.index, "[_na] filter malformed, no field after start_object");
        }
        String filterName = this.parser.currentName();
        token = this.parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT && token != XContentParser.Token.START_ARRAY) {
            throw new QueryParsingException(this.index, "[_na] filter malformed, no field after start_object");
        }
        FilterParser filterParser = this.indexQueryParser.filterParser(filterName);
        if (filterParser == null) {
            throw new QueryParsingException(this.index, "No filter registered for [" + filterName + "]");
        }
        Filter result2 = filterParser.parse(this);
        if (this.parser.currentToken() == XContentParser.Token.END_OBJECT || this.parser.currentToken() == XContentParser.Token.END_ARRAY) {
            this.parser.nextToken();
        }
        return result2;
    }

    public Filter parseInnerFilter(String filterName) throws IOException, QueryParsingException {
        FilterParser filterParser = this.indexQueryParser.filterParser(filterName);
        if (filterParser == null) {
            throw new QueryParsingException(this.index, "No filter registered for [" + filterName + "]");
        }
        Filter result2 = filterParser.parse(this);
        return result2;
    }

    public FieldMapper fieldMapper(String name2) {
        FieldMappers fieldMappers = this.indexQueryParser.mapperService.smartNameFieldMappers(name2, QueryParseContext.getTypes());
        if (fieldMappers == null) {
            return null;
        }
        return fieldMappers.mapper();
    }

    public String indexName(String name2) {
        FieldMapper smartMapper = this.fieldMapper(name2);
        if (smartMapper == null) {
            return name2;
        }
        return smartMapper.names().indexName();
    }

    public MapperService.SmartNameFieldMappers smartFieldMappers(String name2) {
        return this.indexQueryParser.mapperService.smartName(name2, QueryParseContext.getTypes());
    }

    public MapperService.SmartNameObjectMapper smartObjectMapper(String name2) {
        return this.indexQueryParser.mapperService.smartNameObjectMapper(name2, QueryParseContext.getTypes());
    }

    public Collection<String> queryTypes() {
        String[] types = QueryParseContext.getTypes();
        if (types == null || types.length == 0) {
            return this.mapperService().types();
        }
        if (types.length == 1 && types[0].equals("_all")) {
            return this.mapperService().types();
        }
        return Arrays.asList(types);
    }

    public SearchLookup lookup() {
        SearchContext current2 = SearchContext.current();
        if (current2 != null) {
            return current2.lookup();
        }
        if (this.lookup == null) {
            this.lookup = new SearchLookup(this.mapperService(), this.indexCache().fieldData(), null);
        }
        return this.lookup;
    }

    public long nowInMillis() {
        SearchContext current2 = SearchContext.current();
        if (current2 != null) {
            return current2.nowInMillis();
        }
        return System.currentTimeMillis();
    }
}

