/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.PrefixFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class PrefixFilterParser
implements FilterParser {
    public static final String NAME = "prefix";

    @Inject
    public PrefixFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean cache = true;
        CacheKeyFilter.Key cacheKey = null;
        String fieldName = null;
        String value2 = null;
        String filterName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue()) continue;
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                cacheKey = new CacheKeyFilter.Key(parser.text());
                continue;
            }
            fieldName = currentFieldName;
            value2 = parser.text();
        }
        if (value2 == null) {
            throw new QueryParsingException(parseContext.index(), "No value specified for prefix filter");
        }
        Filter filter = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            if (smartNameFieldMappers.explicitTypeInNameWithDocMapper()) {
                String[] previousTypes = QueryParseContext.setTypesWithPrevious(new String[]{smartNameFieldMappers.docMapper().type()});
                try {
                    filter = smartNameFieldMappers.mapper().prefixFilter(value2, parseContext);
                }
                finally {
                    QueryParseContext.setTypes(previousTypes);
                }
            } else {
                filter = smartNameFieldMappers.mapper().prefixFilter(value2, parseContext);
            }
        }
        if (filter == null) {
            filter = new PrefixFilter(new Term(fieldName, value2));
        }
        if (cache) {
            filter = parseContext.cacheFilter(filter, cacheKey);
        }
        filter = QueryParsers.wrapSmartNameFilter(filter, smartNameFieldMappers, parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

