/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;
import org.elasticsearch.index.query.QueryBuilderException;
import org.elasticsearch.index.search.geo.Point;

public class GeoBoundingBoxFilterBuilder
extends BaseFilterBuilder {
    private final String name;
    private Point topLeft;
    private String topLeftGeohash;
    private Point bottomRight;
    private String bottomRightGeohash;
    private Boolean cache;
    private String cacheKey;
    private String filterName;
    private String type;

    public GeoBoundingBoxFilterBuilder(String name2) {
        this.name = name2;
    }

    public GeoBoundingBoxFilterBuilder topLeft(double lat, double lon) {
        this.topLeft = new Point();
        this.topLeft.lat = lat;
        this.topLeft.lon = lon;
        return this;
    }

    public GeoBoundingBoxFilterBuilder bottomRight(double lat, double lon) {
        this.bottomRight = new Point();
        this.bottomRight.lat = lat;
        this.bottomRight.lon = lon;
        return this;
    }

    public GeoBoundingBoxFilterBuilder topLeft(String geohash) {
        this.topLeftGeohash = geohash;
        return this;
    }

    public GeoBoundingBoxFilterBuilder bottomRight(String geohash) {
        this.bottomRightGeohash = geohash;
        return this;
    }

    public GeoBoundingBoxFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public GeoBoundingBoxFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public GeoBoundingBoxFilterBuilder cacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
        return this;
    }

    public GeoBoundingBoxFilterBuilder type(String type2) {
        this.type = type2;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject("geo_bbox");
        builder.startObject(this.name);
        if (this.topLeftGeohash != null) {
            builder.field("top_left", this.topLeftGeohash);
        } else if (this.topLeft != null) {
            builder.startArray("top_left").value(this.topLeft.lon).value(this.topLeft.lat).endArray();
        } else {
            throw new QueryBuilderException("geo_bounding_box requires 'top_left' to be set");
        }
        if (this.bottomRightGeohash != null) {
            builder.field("bottom_right", this.bottomRightGeohash);
        } else if (this.bottomRight != null) {
            builder.startArray("bottom_right").value(this.bottomRight.lon).value(this.bottomRight.lat).endArray();
        } else {
            throw new QueryBuilderException("geo_bounding_box requires 'bottom_right' to be set");
        }
        builder.endObject();
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        if (this.cacheKey != null) {
            builder.field("_cache_key", this.cacheKey);
        }
        if (this.type != null) {
            builder.field("type", this.type);
        }
        builder.endObject();
    }
}

