/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;

public class AndFilterBuilder
extends BaseFilterBuilder {
    private ArrayList<FilterBuilder> filters = Lists.newArrayList();
    private Boolean cache;
    private String cacheKey;
    private String filterName;

    public AndFilterBuilder(FilterBuilder ... filters) {
        for (FilterBuilder filter : filters) {
            this.filters.add(filter);
        }
    }

    public AndFilterBuilder add(FilterBuilder filterBuilder) {
        this.filters.add(filterBuilder);
        return this;
    }

    public AndFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public AndFilterBuilder cacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
        return this;
    }

    public AndFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject("and");
        builder.startArray("filters");
        for (FilterBuilder filter : this.filters) {
            filter.toXContent(builder, params2);
        }
        builder.endArray();
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        if (this.cacheKey != null) {
            builder.field("_cache_key", this.cacheKey);
        }
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        builder.endObject();
    }
}

