/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.percolator;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.memory.CustomMemoryIndex;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.percolator.PercolateIndexUnavailable;
import org.elasticsearch.index.percolator.PercolatorException;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;

public class PercolatorExecutor
extends AbstractIndexComponent {
    private final MapperService mapperService;
    private final IndexQueryParserService queryParserService;
    private final IndexCache indexCache;
    private final Map<String, Query> queries = ConcurrentCollections.newConcurrentMap();
    private IndicesService indicesService;

    @Inject
    public PercolatorExecutor(Index index2, @IndexSettings Settings indexSettings, MapperService mapperService, IndexQueryParserService queryParserService, IndexCache indexCache) {
        super(index2, indexSettings);
        this.mapperService = mapperService;
        this.queryParserService = queryParserService;
        this.indexCache = indexCache;
    }

    public void setIndicesService(IndicesService indicesService) {
        this.indicesService = indicesService;
    }

    public void close() {
        this.queries.clear();
    }

    public void addQuery(String name2, QueryBuilder queryBuilder) throws ElasticSearchException {
        try {
            XContentBuilder builder = XContentFactory.smileBuilder().startObject().field("query", queryBuilder).endObject();
            this.addQuery(name2, builder.bytes());
        }
        catch (IOException e) {
            throw new ElasticSearchException("Failed to add query [" + name2 + "]", e);
        }
    }

    public void addQuery(String name2, BytesReference source2) throws ElasticSearchException {
        this.addQuery(name2, this.parseQuery(name2, source2));
    }

    public Query parseQuery(String name2, BytesReference source2) throws ElasticSearchException {
        XContentParser parser = null;
        try {
            parser = XContentHelper.createParser(source2);
            Query query = null;
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ElasticSearchException("failed to parse query [" + name2 + "], not starting with OBJECT");
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("query".equals(currentFieldName)) {
                        query = this.queryParserService.parse(parser).query();
                        break;
                    }
                    parser.skipChildren();
                    continue;
                }
                if (token != XContentParser.Token.START_ARRAY) continue;
                parser.skipChildren();
            }
            Query query2 = query;
            return query2;
        }
        catch (Exception e) {
            throw new ElasticSearchException("failed to parse query [" + name2 + "]", e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    private void addQuery(String name2, Query query) {
        Preconditions.checkArgument(query != null, "query must be provided for percolate request");
        this.queries.put(name2, query);
    }

    public void removeQuery(String name2) {
        this.queries.remove(name2);
    }

    public void addQueries(Map<String, Query> queries) {
        this.queries.putAll(queries);
    }

    public Response percolate(SourceRequest request) throws ElasticSearchException {
        Query query = null;
        ParsedDocument doc = null;
        XContentParser parser = null;
        try {
            XContentParser.Token token;
            parser = XContentFactory.xContent(request.source()).createParser(request.source());
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    if (!"doc".equals(currentFieldName)) continue;
                    DocumentMapper docMapper = this.mapperService.documentMapperWithAutoCreate(request.type());
                    doc = docMapper.parse(SourceToParse.source(parser).type(request.type()).flyweight(true));
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (!"query".equals(currentFieldName)) continue;
                    query = this.percolatorIndexServiceSafe().queryParserService().parse(parser).query();
                    continue;
                }
                if (token != null) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new PercolatorException(this.index, "failed to parse request", e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
        if (doc == null) {
            throw new PercolatorException(this.index, "No doc to percolate in the request");
        }
        return this.percolate(new DocAndQueryRequest(doc, query));
    }

    public Response percolate(DocAndSourceQueryRequest request) throws ElasticSearchException {
        Query query = null;
        if (Strings.hasLength(request.query()) && !request.query().equals("*")) {
            query = this.percolatorIndexServiceSafe().queryParserService().parse(QueryBuilders.queryString(request.query())).query();
        }
        return this.percolate(new DocAndQueryRequest(request.doc(), query));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response percolate(DocAndQueryRequest request) throws ElasticSearchException {
        ArrayList<String> matches;
        block20: {
            CustomMemoryIndex memoryIndex = new CustomMemoryIndex();
            for (Fieldable field2 : request.doc().rootDoc().getFields()) {
                if (!field2.isIndexed() || field2.name().equals(UidFieldMapper.NAME)) continue;
                TokenStream tokenStream = field2.tokenStreamValue();
                if (tokenStream != null) {
                    memoryIndex.addField(field2.name(), tokenStream, field2.getBoost());
                    continue;
                }
                Reader reader = field2.readerValue();
                if (reader != null) {
                    try {
                        memoryIndex.addField(field2.name(), request.doc().analyzer().reusableTokenStream(field2.name(), reader), field2.getBoost() * request.doc().rootDoc().getBoost());
                        continue;
                    }
                    catch (IOException e) {
                        throw new MapperParsingException("Failed to analyze field [" + field2.name() + "]", e);
                    }
                }
                String value2 = field2.stringValue();
                if (value2 == null) continue;
                try {
                    memoryIndex.addField(field2.name(), request.doc().analyzer().reusableTokenStream(field2.name(), new FastStringReader(value2)), field2.getBoost() * request.doc().rootDoc().getBoost());
                }
                catch (IOException e) {
                    throw new MapperParsingException("Failed to analyze field [" + field2.name() + "]", e);
                }
            }
            IndexSearcher searcher = memoryIndex.createSearcher();
            matches = new ArrayList<String>();
            try {
                if (request.query() == null) {
                    Lucene.ExistsCollector collector = new Lucene.ExistsCollector();
                    for (Map.Entry<String, Query> entry : this.queries.entrySet()) {
                        collector.reset();
                        try {
                            searcher.search(entry.getValue(), collector);
                        }
                        catch (IOException e) {
                            this.logger.warn("[" + entry.getKey() + "] failed to execute query", e, new Object[0]);
                        }
                        if (!collector.exists()) continue;
                        matches.add(entry.getKey());
                    }
                    break block20;
                }
                IndexService percolatorIndex = this.percolatorIndexServiceSafe();
                if (percolatorIndex.numberOfShards() == 0) {
                    throw new PercolateIndexUnavailable(new Index("_percolator"));
                }
                IndexShard percolatorShard = percolatorIndex.shard(0);
                Engine.Searcher percolatorSearcher = percolatorShard.searcher();
                try {
                    percolatorSearcher.searcher().search(request.query(), new QueryCollector(this.logger, this.queries, searcher, percolatorIndex, matches));
                }
                catch (IOException e) {
                    this.logger.warn("failed to execute", e, new Object[0]);
                }
                finally {
                    percolatorSearcher.release();
                }
            }
            finally {
                this.indexCache.clear(searcher.getIndexReader());
            }
        }
        return new Response(matches, request.doc().mappingsModified());
    }

    private IndexService percolatorIndexServiceSafe() {
        IndexService indexService = this.indicesService.indexService("_percolator");
        if (indexService == null) {
            throw new PercolateIndexUnavailable(new Index("_percolator"));
        }
        return indexService;
    }

    static class QueryCollector
    extends Collector {
        private final IndexSearcher searcher;
        private final IndexService percolatorIndex;
        private final List<String> matches;
        private final Map<String, Query> queries;
        private final ESLogger logger;
        private final Lucene.ExistsCollector collector = new Lucene.ExistsCollector();
        private FieldData fieldData;

        QueryCollector(ESLogger logger, Map<String, Query> queries, IndexSearcher searcher, IndexService percolatorIndex, List<String> matches) {
            this.logger = logger;
            this.queries = queries;
            this.searcher = searcher;
            this.percolatorIndex = percolatorIndex;
            this.matches = matches;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
        }

        @Override
        public void collect(int doc) throws IOException {
            String uid2 = this.fieldData.stringValue(doc);
            if (uid2 == null) {
                return;
            }
            String id2 = Uid.idFromUid(uid2);
            Query query = this.queries.get(id2);
            if (query == null) {
                return;
            }
            try {
                this.collector.reset();
                this.searcher.search(query, this.collector);
                if (this.collector.exists()) {
                    this.matches.add(id2);
                }
            }
            catch (IOException e) {
                this.logger.warn("[" + id2 + "] failed to execute query", e, new Object[0]);
            }
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.fieldData = this.percolatorIndex.cache().fieldData().cache(FieldDataType.DefaultTypes.STRING, reader, UidFieldMapper.NAME);
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    public static final class Response {
        private final List<String> matches;
        private final boolean mappersAdded;

        public Response(List<String> matches, boolean mappersAdded) {
            this.matches = matches;
            this.mappersAdded = mappersAdded;
        }

        public boolean mappersAdded() {
            return this.mappersAdded;
        }

        public List<String> matches() {
            return this.matches;
        }
    }

    public static class DocAndQueryRequest {
        private final ParsedDocument doc;
        @Nullable
        private final Query query;

        public DocAndQueryRequest(ParsedDocument doc, @Nullable Query query) {
            this.doc = doc;
            this.query = query;
        }

        public ParsedDocument doc() {
            return this.doc;
        }

        @Nullable
        Query query() {
            return this.query;
        }
    }

    public static class DocAndSourceQueryRequest {
        private final ParsedDocument doc;
        @Nullable
        private final String query;

        public DocAndSourceQueryRequest(ParsedDocument doc, @Nullable String query) {
            this.doc = doc;
            this.query = query;
        }

        public ParsedDocument doc() {
            return this.doc;
        }

        @Nullable
        String query() {
            return this.query;
        }
    }

    public static class SourceRequest {
        private final String type;
        private final BytesReference source;

        public SourceRequest(String type2, BytesReference source2) {
            this.type = type2;
            this.source = source2;
        }

        public String type() {
            return this.type;
        }

        public BytesReference source() {
            return this.source;
        }
    }
}

