/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.object;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.MapperParsingException;

public class DynamicTemplate {
    private final String name;
    private final Map<String, Object> conf;
    private final String pathMatch;
    private final String pathUnmatch;
    private final String match;
    private final String unmatch;
    private final MatchType matchType;
    private final String matchMappingType;
    private final Map<String, Object> mapping;

    public static DynamicTemplate parse(String name2, Map<String, Object> conf) throws MapperParsingException {
        String match2 = null;
        String pathMatch = null;
        String unmatch = null;
        String pathUnmatch = null;
        Map mapping = null;
        String matchMappingType = null;
        String matchPattern = "simple";
        for (Map.Entry<String, Object> entry : conf.entrySet()) {
            String propName = Strings.toUnderscoreCase(entry.getKey());
            if ("match".equals(propName)) {
                match2 = entry.getValue().toString();
                continue;
            }
            if ("path_match".equals(propName)) {
                pathMatch = entry.getValue().toString();
                continue;
            }
            if ("unmatch".equals(propName)) {
                unmatch = entry.getValue().toString();
                continue;
            }
            if ("path_unmatch".equals(propName)) {
                pathUnmatch = entry.getValue().toString();
                continue;
            }
            if ("match_mapping_type".equals(propName)) {
                matchMappingType = entry.getValue().toString();
                continue;
            }
            if ("match_pattern".equals(propName)) {
                matchPattern = entry.getValue().toString();
                continue;
            }
            if (!"mapping".equals(propName)) continue;
            mapping = (Map)entry.getValue();
        }
        if (match2 == null && pathMatch == null) {
            throw new MapperParsingException("template must have match or path_match set");
        }
        if (mapping == null) {
            throw new MapperParsingException("template must have mapping set");
        }
        return new DynamicTemplate(name2, conf, pathMatch, pathUnmatch, match2, unmatch, matchMappingType, MatchType.fromString(matchPattern), mapping);
    }

    public DynamicTemplate(String name2, Map<String, Object> conf, String pathMatch, String pathUnmatch, String match2, String unmatch, String matchMappingType, MatchType matchType, Map<String, Object> mapping) {
        this.name = name2;
        this.conf = new TreeMap<String, Object>(conf);
        this.pathMatch = pathMatch;
        this.pathUnmatch = pathUnmatch;
        this.match = match2;
        this.unmatch = unmatch;
        this.matchType = matchType;
        this.matchMappingType = matchMappingType;
        this.mapping = mapping;
    }

    public String name() {
        return this.name;
    }

    public Map<String, Object> conf() {
        return this.conf;
    }

    public boolean match(ContentPath path2, String name2, String dynamicType) {
        if (this.pathMatch != null && !this.patternMatch(this.pathMatch, path2.fullPathAsText(name2))) {
            return false;
        }
        if (this.match != null && !this.patternMatch(this.match, name2)) {
            return false;
        }
        if (this.pathUnmatch != null && this.patternMatch(this.pathUnmatch, path2.fullPathAsText(name2))) {
            return false;
        }
        if (this.unmatch != null && this.patternMatch(this.unmatch, name2)) {
            return false;
        }
        if (this.matchMappingType != null) {
            if (dynamicType == null) {
                return false;
            }
            if (!this.patternMatch(this.matchMappingType, dynamicType)) {
                return false;
            }
        }
        return true;
    }

    public boolean hasType() {
        return this.mapping.containsKey("type");
    }

    public String mappingType(String dynamicType) {
        return this.mapping.containsKey("type") ? this.mapping.get("type").toString() : dynamicType;
    }

    private boolean patternMatch(String pattern, String str) {
        if (this.matchType == MatchType.SIMPLE) {
            return Regex.simpleMatch(pattern, str);
        }
        return str.matches(pattern);
    }

    public Map<String, Object> mappingForName(String name2, String dynamicType) {
        return this.processMap(this.mapping, name2, dynamicType);
    }

    private Map<String, Object> processMap(Map<String, Object> map, String name2, String dynamicType) {
        HashMap<String, Object> processedMap = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key2 = entry.getKey().replace("{name}", name2).replace("{dynamic_type}", dynamicType).replace("{dynamicType}", dynamicType);
            Map<String, Object> value2 = entry.getValue();
            if (value2 instanceof Map) {
                value2 = this.processMap(value2, name2, dynamicType);
            } else if (value2 instanceof List) {
                value2 = this.processList((List)((Object)value2), name2, dynamicType);
            } else if (value2 instanceof String) {
                value2 = value2.toString().replace("{name}", name2).replace("{dynamic_type}", dynamicType).replace("{dynamicType}", dynamicType);
            }
            processedMap.put(key2, value2);
        }
        return processedMap;
    }

    private List processList(List list2, String name2, String dynamicType) {
        ArrayList<Object> processedList = new ArrayList<Object>();
        for (Object value2 : list2) {
            if (value2 instanceof Map) {
                value2 = this.processMap((Map)value2, name2, dynamicType);
            } else if (value2 instanceof List) {
                value2 = this.processList((List)value2, name2, dynamicType);
            } else if (value2 instanceof String) {
                value2 = value2.toString().replace("{name}", name2).replace("{dynamic_type}", dynamicType).replace("{dynamicType}", dynamicType);
            }
            processedList.add(value2);
        }
        return processedList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicTemplate that = (DynamicTemplate)o;
        if (this.match != null ? !this.match.equals(that.match) : that.match != null) {
            return false;
        }
        if (this.matchMappingType != null ? !this.matchMappingType.equals(that.matchMappingType) : that.matchMappingType != null) {
            return false;
        }
        if (this.matchType != that.matchType) {
            return false;
        }
        return !(this.unmatch != null ? !this.unmatch.equals(that.unmatch) : that.unmatch != null);
    }

    public int hashCode() {
        int result2 = this.match != null ? this.match.hashCode() : 0;
        result2 = 31 * result2 + (this.unmatch != null ? this.unmatch.hashCode() : 0);
        result2 = 31 * result2 + (this.matchType != null ? this.matchType.hashCode() : 0);
        result2 = 31 * result2 + (this.matchMappingType != null ? this.matchMappingType.hashCode() : 0);
        return result2;
    }

    public static enum MatchType {
        SIMPLE,
        REGEX;


        public static MatchType fromString(String value2) {
            if ("simple".equals(value2)) {
                return SIMPLE;
            }
            if ("regex".equals(value2)) {
                return REGEX;
            }
            throw new ElasticSearchIllegalArgumentException("No matching pattern matched on [" + value2 + "]");
        }
    }
}

