/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;

public class RoutingFieldMapper
extends AbstractFieldMapper<String>
implements InternalMapper,
RootMapper {
    public static final String NAME = "_routing";
    public static final String CONTENT_TYPE = "_routing";
    private boolean required;
    private final String path;

    public RoutingFieldMapper() {
        this(Defaults.STORE, Defaults.INDEX, false, Defaults.PATH);
    }

    protected RoutingFieldMapper(Field.Store store, Field.Index index2, boolean required, String path2) {
        super(new FieldMapper.Names("_routing", "_routing", "_routing", "_routing"), index2, store, Defaults.TERM_VECTOR, 1.0f, true, Defaults.INDEX_OPTIONS, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
        this.required = required;
        this.path = path2;
    }

    public void markAsRequired() {
        this.required = true;
    }

    public boolean required() {
        return this.required;
    }

    public String path() {
        return this.path;
    }

    public String value(Document document) {
        Fieldable field2 = document.getFieldable(this.names.indexName());
        return field2 == null ? null : this.value(field2);
    }

    @Override
    public String value(Fieldable field2) {
        return field2.stringValue();
    }

    @Override
    public String valueFromString(String value2) {
        return value2;
    }

    @Override
    public String valueAsString(Fieldable field2) {
        return this.value(field2);
    }

    @Override
    public String indexedValue(String value2) {
        return value2;
    }

    @Override
    public void validate(ParseContext context) throws MapperParsingException {
        String routing = context.sourceToParse().routing();
        if (this.path != null && routing != null) {
            String value2 = null;
            Fieldable field2 = context.doc().getFieldable(this.path);
            if (field2 != null && (value2 = field2.stringValue()) == null && field2 instanceof NumberFieldMapper.CustomNumericField) {
                value2 = ((NumberFieldMapper.CustomNumericField)field2).numericAsString();
            }
            if (value2 == null) {
                value2 = context.ignoredValue(this.path);
            }
            if (!routing.equals(value2)) {
                throw new MapperParsingException("External routing [" + routing + "] and document path routing [" + value2 + "] mismatch");
            }
        }
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public boolean includeInObject() {
        return true;
    }

    @Override
    protected Field parseCreateField(ParseContext context) throws IOException {
        String routing;
        if (context.sourceToParse().routing() != null && (routing = context.sourceToParse().routing()) != null) {
            if (!this.indexed() && !this.stored()) {
                context.ignoredValue(this.names.indexName(), routing);
                return null;
            }
            return new Field(this.names.indexName(), routing, this.store, this.index);
        }
        return null;
    }

    @Override
    protected String contentType() {
        return "_routing";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        if (this.index == Defaults.INDEX && this.store == Defaults.STORE && !this.required && this.path == Defaults.PATH) {
            return builder;
        }
        builder.startObject("_routing");
        if (this.index != Defaults.INDEX) {
            builder.field("index", this.index.name().toLowerCase());
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.required) {
            builder.field("required", this.required);
        }
        if (this.path != Defaults.PATH) {
            builder.field("path", this.path);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name2, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.routing();
            TypeParsers.parseField(builder, builder.name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("required")) {
                    builder.required(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (!fieldName.equals("path")) continue;
                builder.path(fieldNode.toString());
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, RoutingFieldMapper> {
        private boolean required = false;
        private String path = Defaults.PATH;

        public Builder() {
            super("_routing");
            this.store = Defaults.STORE;
            this.index = Defaults.INDEX;
        }

        public Builder required(boolean required) {
            this.required = required;
            return (Builder)this.builder;
        }

        public Builder path(String path2) {
            this.path = path2;
            return (Builder)this.builder;
        }

        @Override
        public RoutingFieldMapper build(Mapper.BuilderContext context) {
            return new RoutingFieldMapper(this.store, this.index, this.required, this.path);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_routing";
        public static final Field.Index INDEX = Field.Index.NOT_ANALYZED;
        public static final Field.Store STORE = Field.Store.YES;
        public static final boolean OMIT_NORMS = true;
        public static final FieldInfo.IndexOptions INDEX_OPTIONS = FieldInfo.IndexOptions.DOCS_ONLY;
        public static final boolean REQUIRED = false;
        public static final String PATH = null;
    }
}

