/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.geo;

import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.util.concurrent.ThreadLocals;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.doubles.DoubleFieldData;
import org.elasticsearch.index.mapper.geo.GeoPoint;
import org.elasticsearch.index.mapper.geo.GeoPointFieldData;
import org.elasticsearch.index.search.geo.GeoHashUtils;

public class MultiValueGeoPointFieldData
extends GeoPointFieldData {
    private static final int VALUE_CACHE_SIZE = 100;
    private static ThreadLocal<ThreadLocals.CleanableValue<GeoPoint[][]>> valuesArrayCache = new ThreadLocal<ThreadLocals.CleanableValue<GeoPoint[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<GeoPoint[][]> initialValue() {
            GeoPoint[][] value2 = new GeoPoint[100][];
            for (int i2 = 0; i2 < value2.length; ++i2) {
                value2[i2] = new GeoPoint[i2];
                for (int j = 0; j < value2[i2].length; ++j) {
                    value2[i2][j] = new GeoPoint();
                }
            }
            return new ThreadLocals.CleanableValue<GeoPoint[][]>(value2);
        }
    };
    private ThreadLocal<ThreadLocals.CleanableValue<double[][]>> valuesLatCache = new ThreadLocal<ThreadLocals.CleanableValue<double[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<double[][]> initialValue() {
            double[][] value2 = new double[100][];
            for (int i2 = 0; i2 < value2.length; ++i2) {
                value2[i2] = new double[i2];
            }
            return new ThreadLocals.CleanableValue<double[][]>(value2);
        }
    };
    private ThreadLocal<ThreadLocals.CleanableValue<double[][]>> valuesLonCache = new ThreadLocal<ThreadLocals.CleanableValue<double[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<double[][]> initialValue() {
            double[][] value2 = new double[100][];
            for (int i2 = 0; i2 < value2.length; ++i2) {
                value2[i2] = new double[i2];
            }
            return new ThreadLocals.CleanableValue<double[][]>(value2);
        }
    };
    private final int[][] ordinals;

    public MultiValueGeoPointFieldData(String fieldName, int[][] ordinals, double[] lat, double[] lon) {
        super(fieldName, lat, lon);
        this.ordinals = ordinals;
    }

    @Override
    protected long computeSizeInBytes() {
        long size2 = super.computeSizeInBytes();
        size2 += (long)RamUsage.NUM_BYTES_ARRAY_HEADER;
        for (int[] ordinal : this.ordinals) {
            size2 += (long)(4 * ordinal.length + RamUsage.NUM_BYTES_ARRAY_HEADER);
        }
        return size2;
    }

    @Override
    public boolean multiValued() {
        return true;
    }

    @Override
    public boolean hasValue(int docId) {
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEachValueInDoc(int docId, FieldData.StringValueInDocProc proc2) {
        for (int i2 = 0; i2 < this.ordinals.length; ++i2) {
            int loc = this.ordinals[i2][docId];
            if (loc == 0) {
                if (i2 != 0) break;
                proc2.onMissing(docId);
                break;
            }
            proc2.onValue(docId, GeoHashUtils.encode(this.lat[loc], this.lon[loc]));
        }
    }

    @Override
    public void forEachValueInDoc(int docId, GeoPointFieldData.ValueInDocProc proc2) {
        int[] ordinal;
        int loc;
        int[][] arr$ = this.ordinals;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (loc = (ordinal = arr$[i$])[docId]) != 0; ++i$) {
            proc2.onValue(docId, this.lat[loc], this.lon[loc]);
        }
    }

    @Override
    public void forEachOrdinalInDoc(int docId, FieldData.OrdinalInDocProc proc2) {
        for (int i2 = 0; i2 < this.ordinals.length; ++i2) {
            int loc = this.ordinals[i2][docId];
            if (loc == 0) {
                if (i2 != 0) break;
                proc2.onOrdinal(docId, 0);
                break;
            }
            proc2.onOrdinal(docId, loc);
        }
    }

    @Override
    public GeoPoint value(int docId) {
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            GeoPoint point = (GeoPoint)((ThreadLocals.CleanableValue)valuesCache.get()).get();
            point.latlon(this.lat[loc], this.lon[loc]);
            return point;
        }
        return null;
    }

    @Override
    public GeoPoint[] values(int docId) {
        int loc;
        int i2;
        GeoPoint[] points;
        int length2 = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) break;
            ++length2;
        }
        if (length2 == 0) {
            return EMPTY_ARRAY;
        }
        if (length2 < 100) {
            points = valuesArrayCache.get().get()[length2];
            for (i2 = 0; i2 < length2; ++i2) {
                loc = this.ordinals[i2][docId];
                points[i2].latlon(this.lat[loc], this.lon[loc]);
            }
        } else {
            points = new GeoPoint[length2];
            for (i2 = 0; i2 < length2; ++i2) {
                loc = this.ordinals[i2][docId];
                points[i2] = new GeoPoint(this.lat[loc], this.lon[loc]);
            }
        }
        return points;
    }

    @Override
    public double latValue(int docId) {
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            return this.lat[loc];
        }
        return 0.0;
    }

    @Override
    public double lonValue(int docId) {
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            return this.lon[loc];
        }
        return 0.0;
    }

    @Override
    public double[] latValues(int docId) {
        int length2 = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) break;
            ++length2;
        }
        if (length2 == 0) {
            return DoubleFieldData.EMPTY_DOUBLE_ARRAY;
        }
        double[] doubles = length2 < 100 ? this.valuesLatCache.get().get()[length2] : new double[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            doubles[i2] = this.lat[this.ordinals[i2][docId]];
        }
        return doubles;
    }

    @Override
    public double[] lonValues(int docId) {
        int length2 = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            ++length2;
        }
        if (length2 == 0) {
            return DoubleFieldData.EMPTY_DOUBLE_ARRAY;
        }
        double[] doubles = length2 < 100 ? this.valuesLonCache.get().get()[length2] : new double[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            doubles[i2] = this.lon[this.ordinals[i2][docId]];
        }
        return doubles;
    }
}

