/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericFloatAnalyzer;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;

public class FloatFieldMapper
extends NumberFieldMapper<Float> {
    public static final String CONTENT_TYPE = "float";
    private Float nullValue;
    private String nullValueAsString;

    protected FloatFieldMapper(FieldMapper.Names names2, int precisionStep, String fuzzyFactor, Field.Index index2, Field.Store store, float boost, boolean omitNorms, FieldInfo.IndexOptions indexOptions, Float nullValue, Explicit<Boolean> ignoreMalformed) {
        super(names2, precisionStep, fuzzyFactor, index2, store, boost, omitNorms, indexOptions, ignoreMalformed, new NamedAnalyzer("_float/" + precisionStep, new NumericFloatAnalyzer(precisionStep)), new NamedAnalyzer("_float/max", new NumericFloatAnalyzer(Integer.MAX_VALUE)));
        this.nullValue = nullValue;
        this.nullValueAsString = nullValue == null ? null : nullValue.toString();
    }

    @Override
    protected int maxPrecisionStep() {
        return 32;
    }

    @Override
    public Float value(Fieldable field2) {
        byte[] value2 = field2.getBinaryValue();
        if (value2 == null) {
            return null;
        }
        return Float.valueOf(Numbers.bytesToFloat(value2));
    }

    @Override
    public Float valueFromString(String value2) {
        return Float.valueOf(Float.parseFloat(value2));
    }

    @Override
    public String indexedValue(String value2) {
        return NumericUtils.floatToPrefixCoded(Float.parseFloat(value2));
    }

    @Override
    public Query fuzzyQuery(String value2, String minSim, int prefixLength, int maxExpansions) {
        float iValue = Float.parseFloat(value2);
        float iSim = Float.parseFloat(minSim);
        return NumericRangeQuery.newFloatRange(this.names.indexName(), this.precisionStep, Float.valueOf(iValue - iSim), Float.valueOf(iValue + iSim), true, true);
    }

    @Override
    public Query fuzzyQuery(String value2, double minSim, int prefixLength, int maxExpansions) {
        float iValue = Float.parseFloat(value2);
        float iSim = (float)(minSim * this.dFuzzyFactor);
        return NumericRangeQuery.newFloatRange(this.names.indexName(), this.precisionStep, Float.valueOf(iValue - iSim), Float.valueOf(iValue + iSim), true, true);
    }

    @Override
    public Query fieldQuery(String value2, @Nullable QueryParseContext context) {
        float fValue = Float.parseFloat(value2);
        return NumericRangeQuery.newFloatRange(this.names.indexName(), this.precisionStep, Float.valueOf(fValue), Float.valueOf(fValue), true, true);
    }

    @Override
    public Query rangeQuery(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeQuery.newFloatRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Float.valueOf(Float.parseFloat(lowerTerm)), upperTerm == null ? null : Float.valueOf(Float.parseFloat(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter fieldFilter(String value2, @Nullable QueryParseContext context) {
        float fValue = Float.parseFloat(value2);
        return NumericRangeFilter.newFloatRange(this.names.indexName(), this.precisionStep, Float.valueOf(fValue), Float.valueOf(fValue), true, true);
    }

    @Override
    public Filter rangeFilter(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFilter.newFloatRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Float.valueOf(Float.parseFloat(lowerTerm)), upperTerm == null ? null : Float.valueOf(Float.parseFloat(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter rangeFilter(FieldDataCache fieldDataCache, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFieldDataFilter.newFloatRange(fieldDataCache, this.names.indexName(), lowerTerm == null ? null : Float.valueOf(Float.parseFloat(lowerTerm)), upperTerm == null ? null : Float.valueOf(Float.parseFloat(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter nullValueFilter() {
        if (this.nullValue == null) {
            return null;
        }
        return NumericRangeFilter.newFloatRange(this.names.indexName(), this.precisionStep, this.nullValue, this.nullValue, true, true);
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    @Override
    protected Fieldable innerParseCreateField(ParseContext context) throws IOException {
        float value2;
        float boost = this.boost;
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue == null) {
                if (this.nullValue == null) {
                    return null;
                }
                value2 = this.nullValue.floatValue();
            } else if (externalValue instanceof String) {
                String sExternalValue = (String)externalValue;
                if (sExternalValue.length() == 0) {
                    if (this.nullValue == null) {
                        return null;
                    }
                    value2 = this.nullValue.floatValue();
                } else {
                    value2 = Float.parseFloat(sExternalValue);
                }
            } else {
                value2 = ((Number)externalValue).floatValue();
            }
            if (context.includeInAll(this.includeInAll, this)) {
                context.allEntries().addText(this.names.fullName(), Float.toString(value2), boost);
            }
        } else {
            XContentParser parser = context.parser();
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL || parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
                if (this.nullValue == null) {
                    return null;
                }
                value2 = this.nullValue.floatValue();
                if (this.nullValueAsString != null && context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.names.fullName(), this.nullValueAsString, boost);
                }
            } else if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token;
                String currentFieldName = null;
                Float objValue = this.nullValue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        objValue = Float.valueOf(parser.floatValue());
                        continue;
                    }
                    if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new ElasticSearchIllegalArgumentException("unknown property [" + currentFieldName + "]");
                }
                if (objValue == null) {
                    return null;
                }
                value2 = objValue.floatValue();
            } else {
                value2 = parser.floatValue();
                if (context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.names.fullName(), parser.text(), boost);
                }
            }
        }
        CustomFloatNumericField field2 = new CustomFloatNumericField((NumberFieldMapper)this, value2);
        field2.setBoost(boost);
        return field2;
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.FLOAT;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.nullValue = ((FloatFieldMapper)mergeWith).nullValue;
            this.nullValueAsString = ((FloatFieldMapper)mergeWith).nullValueAsString;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        super.doXContentBody(builder);
        if (this.index != Defaults.INDEX) {
            builder.field("index", this.index.name().toLowerCase());
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.termVector != Defaults.TERM_VECTOR) {
            builder.field("term_vector", this.termVector.name().toLowerCase());
        }
        if (!this.omitNorms) {
            builder.field("omit_norms", this.omitNorms);
        }
        if (this.indexOptions != Defaults.INDEX_OPTIONS) {
            builder.field("index_options", FloatFieldMapper.indexOptionToString(this.indexOptions));
        }
        if (this.precisionStep != 4) {
            builder.field("precision_step", this.precisionStep);
        }
        if (this.fuzzyFactor != Defaults.FUZZY_FACTOR) {
            builder.field("fuzzy_factor", this.fuzzyFactor);
        }
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        }
    }

    public static class CustomFloatNumericField
    extends NumberFieldMapper.CustomNumericField {
        private final float number;
        private final NumberFieldMapper mapper;

        public CustomFloatNumericField(NumberFieldMapper mapper, float number) {
            super(mapper, mapper.stored() ? Numbers.floatToBytes(number) : null);
            this.mapper = mapper;
            this.number = number;
        }

        @Override
        public TokenStream tokenStreamValue() {
            if (this.isIndexed) {
                return this.mapper.popCachedStream().setFloatValue(this.number);
            }
            return null;
        }

        @Override
        public String numericAsString() {
            return Float.toString(this.number);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name2, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.floatField(name2);
            TypeParsers.parseNumberField(builder, name2, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                builder.nullValue(XContentMapValues.nodeFloatValue(propNode));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, FloatFieldMapper> {
        protected Float nullValue = Defaults.NULL_VALUE;

        public Builder(String name2) {
            super(name2);
            this.builder = this;
        }

        public Builder nullValue(float nullValue) {
            this.nullValue = Float.valueOf(nullValue);
            return this;
        }

        @Override
        public FloatFieldMapper build(Mapper.BuilderContext context) {
            FloatFieldMapper fieldMapper = new FloatFieldMapper(this.buildNames(context), this.precisionStep, this.fuzzyFactor, this.index, this.store, this.boost, this.omitNorms, this.indexOptions, this.nullValue, this.ignoreMalformed(context));
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final Float NULL_VALUE = null;
    }
}

