/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.analysis.FieldNameAnalyzer;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;

public class DocumentFieldMappers
implements Iterable<FieldMapper> {
    private final ImmutableList<FieldMapper> fieldMappers;
    private final Map<String, FieldMappers> fullNameFieldMappers;
    private final Map<String, FieldMappers> nameFieldMappers;
    private final Map<String, FieldMappers> indexNameFieldMappers;
    private final FieldNameAnalyzer indexAnalyzer;
    private final FieldNameAnalyzer searchAnalyzer;
    private final FieldNameAnalyzer searchQuoteAnalyzer;

    public DocumentFieldMappers(DocumentMapper docMapper, Iterable<FieldMapper> fieldMappers) {
        HashMap<String, FieldMappers> tempNameFieldMappers = Maps.newHashMap();
        HashMap<String, FieldMappers> tempIndexNameFieldMappers = Maps.newHashMap();
        HashMap<String, FieldMappers> tempFullNameFieldMappers = Maps.newHashMap();
        HashMap<String, Analyzer> indexAnalyzers = Maps.newHashMap();
        HashMap<String, Analyzer> searchAnalyzers = Maps.newHashMap();
        HashMap<String, Analyzer> searchQuoteAnalyzers = Maps.newHashMap();
        for (FieldMapper fieldMapper : fieldMappers) {
            FieldMappers mappers = (FieldMappers)tempNameFieldMappers.get(fieldMapper.names().name());
            mappers = mappers == null ? new FieldMappers(fieldMapper) : mappers.concat(fieldMapper);
            tempNameFieldMappers.put(fieldMapper.names().name(), mappers);
            mappers = (FieldMappers)tempIndexNameFieldMappers.get(fieldMapper.names().indexName());
            mappers = mappers == null ? new FieldMappers(fieldMapper) : mappers.concat(fieldMapper);
            tempIndexNameFieldMappers.put(fieldMapper.names().indexName(), mappers);
            mappers = (FieldMappers)tempFullNameFieldMappers.get(fieldMapper.names().fullName());
            mappers = mappers == null ? new FieldMappers(fieldMapper) : mappers.concat(fieldMapper);
            tempFullNameFieldMappers.put(fieldMapper.names().fullName(), mappers);
            if (fieldMapper.indexAnalyzer() != null) {
                indexAnalyzers.put(fieldMapper.names().indexName(), fieldMapper.indexAnalyzer());
            }
            if (fieldMapper.searchAnalyzer() != null) {
                searchAnalyzers.put(fieldMapper.names().indexName(), fieldMapper.searchAnalyzer());
            }
            if (fieldMapper.searchQuoteAnalyzer() == null) continue;
            searchQuoteAnalyzers.put(fieldMapper.names().indexName(), fieldMapper.searchQuoteAnalyzer());
        }
        this.fieldMappers = ImmutableList.copyOf(fieldMappers);
        this.nameFieldMappers = ImmutableMap.copyOf(tempNameFieldMappers);
        this.indexNameFieldMappers = ImmutableMap.copyOf(tempIndexNameFieldMappers);
        this.fullNameFieldMappers = ImmutableMap.copyOf(tempFullNameFieldMappers);
        this.indexAnalyzer = new FieldNameAnalyzer(indexAnalyzers, docMapper.indexAnalyzer());
        this.searchAnalyzer = new FieldNameAnalyzer(searchAnalyzers, docMapper.searchAnalyzer());
        this.searchQuoteAnalyzer = new FieldNameAnalyzer(searchQuoteAnalyzers, docMapper.searchQuotedAnalyzer());
    }

    @Override
    public UnmodifiableIterator<FieldMapper> iterator() {
        return this.fieldMappers.iterator();
    }

    public ImmutableList<FieldMapper> mappers() {
        return this.fieldMappers;
    }

    public boolean hasMapper(FieldMapper fieldMapper) {
        return this.fieldMappers.contains(fieldMapper);
    }

    public FieldMappers name(String name2) {
        return this.nameFieldMappers.get(name2);
    }

    public FieldMappers indexName(String indexName) {
        return this.indexNameFieldMappers.get(indexName);
    }

    public FieldMappers fullName(String fullName) {
        return this.fullNameFieldMappers.get(fullName);
    }

    public Set<String> simpleMatchToIndexNames(String pattern) {
        HashSet<String> fields2 = Sets.newHashSet();
        for (FieldMapper fieldMapper : this.fieldMappers) {
            if (Regex.simpleMatch(pattern, fieldMapper.names().fullName())) {
                fields2.add(fieldMapper.names().indexName());
                continue;
            }
            if (Regex.simpleMatch(pattern, fieldMapper.names().indexName())) {
                fields2.add(fieldMapper.names().indexName());
                continue;
            }
            if (!Regex.simpleMatch(pattern, fieldMapper.names().name())) continue;
            fields2.add(fieldMapper.names().indexName());
        }
        return fields2;
    }

    public Set<String> simpleMatchToFullName(String pattern) {
        HashSet<String> fields2 = Sets.newHashSet();
        for (FieldMapper fieldMapper : this.fieldMappers) {
            if (Regex.simpleMatch(pattern, fieldMapper.names().fullName())) {
                fields2.add(fieldMapper.names().fullName());
                continue;
            }
            if (Regex.simpleMatch(pattern, fieldMapper.names().indexName())) {
                fields2.add(fieldMapper.names().fullName());
                continue;
            }
            if (!Regex.simpleMatch(pattern, fieldMapper.names().name())) continue;
            fields2.add(fieldMapper.names().fullName());
        }
        return fields2;
    }

    public FieldMappers smartName(String name2) {
        FieldMappers fieldMappers = this.fullName(name2);
        if (fieldMappers != null) {
            return fieldMappers;
        }
        fieldMappers = this.indexName(name2);
        if (fieldMappers != null) {
            return fieldMappers;
        }
        return this.name(name2);
    }

    public FieldMapper smartNameFieldMapper(String name2) {
        FieldMappers fieldMappers = this.smartName(name2);
        if (fieldMappers == null) {
            return null;
        }
        return fieldMappers.mapper();
    }

    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer indexAnalyzer(Analyzer defaultAnalyzer) {
        return new FieldNameAnalyzer(this.indexAnalyzer.analyzers(), defaultAnalyzer);
    }

    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Analyzer searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer;
    }

    public DocumentFieldMappers concat(DocumentMapper docMapper, FieldMapper ... fieldMappers) {
        return this.concat(docMapper, Lists.newArrayList(fieldMappers));
    }

    public DocumentFieldMappers concat(DocumentMapper docMapper, Iterable<FieldMapper> fieldMappers) {
        return new DocumentFieldMappers(docMapper, Iterables.concat(this.fieldMappers, fieldMappers));
    }
}

