/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

public class ContentPath {
    private Type pathType;
    private final char delimiter;
    private final StringBuilder sb;
    private final int offset;
    private int index = 0;
    private String[] path = new String[10];
    private String sourcePath;

    public ContentPath() {
        this(0);
    }

    public ContentPath(int offset2) {
        this.delimiter = (char)46;
        this.sb = new StringBuilder();
        this.offset = offset2;
        this.reset();
    }

    public void reset() {
        this.index = 0;
        this.sourcePath = null;
    }

    public void add(String name2) {
        this.path[this.index++] = name2;
        if (this.index == this.path.length) {
            String[] newPath = new String[this.path.length + 10];
            System.arraycopy(this.path, 0, newPath, 0, this.path.length);
            this.path = newPath;
        }
    }

    public void remove() {
        this.path[this.index--] = null;
    }

    public String pathAsText(String name2) {
        if (this.pathType == Type.JUST_NAME) {
            return name2;
        }
        return this.fullPathAsText(name2);
    }

    public String fullPathAsText(String name2) {
        this.sb.setLength(0);
        for (int i2 = this.offset; i2 < this.index; ++i2) {
            this.sb.append(this.path[i2]).append(this.delimiter);
        }
        this.sb.append(name2);
        return this.sb.toString();
    }

    public Type pathType() {
        return this.pathType;
    }

    public void pathType(Type type2) {
        this.pathType = type2;
    }

    public String sourcePath(String sourcePath) {
        String orig = this.sourcePath;
        this.sourcePath = sourcePath;
        return orig;
    }

    public String sourcePath() {
        return this.sourcePath;
    }

    public static enum Type {
        JUST_NAME,
        FULL;

    }
}

