/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.document.ResetFieldSelector;
import org.elasticsearch.common.lucene.uid.UidField;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.SizeFieldMapper;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.mapper.selector.FieldMappersFieldSelector;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public class ShardGetService
extends AbstractIndexShardComponent {
    private final ScriptService scriptService;
    private final MapperService mapperService;
    private final IndexCache indexCache;
    private IndexShard indexShard;
    private final MeanMetric existsMetric = new MeanMetric();
    private final MeanMetric missingMetric = new MeanMetric();
    private final CounterMetric currentMetric = new CounterMetric();

    @Inject
    public ShardGetService(ShardId shardId, @IndexSettings Settings indexSettings, ScriptService scriptService, MapperService mapperService, IndexCache indexCache) {
        super(shardId, indexSettings);
        this.scriptService = scriptService;
        this.mapperService = mapperService;
        this.indexCache = indexCache;
    }

    public GetStats stats() {
        return new GetStats(this.existsMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.existsMetric.sum()), this.missingMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.missingMetric.sum()), this.currentMetric.count());
    }

    public ShardGetService setIndexShard(IndexShard indexShard) {
        this.indexShard = indexShard;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult get(String type2, String id2, String[] gFields, boolean realtime) throws ElasticSearchException {
        this.currentMetric.inc();
        try {
            long now = System.nanoTime();
            GetResult getResult = this.innerGet(type2, id2, gFields, realtime);
            if (getResult.exists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult get(Engine.GetResult engineGetResult, String id2, String type2, String[] fields2) {
        if (!engineGetResult.exists()) {
            return new GetResult(this.shardId.index().name(), type2, id2, -1L, false, null, null);
        }
        this.currentMetric.inc();
        try {
            long now = System.nanoTime();
            DocumentMapper docMapper = this.mapperService.documentMapper(type2);
            if (docMapper == null) {
                this.missingMetric.inc(System.nanoTime() - now);
                GetResult getResult = new GetResult(this.shardId.index().name(), type2, id2, -1L, false, null, null);
                return getResult;
            }
            GetResult getResult = this.innerGetLoadFromStoredFields(type2, id2, fields2, engineGetResult, docMapper);
            if (getResult.exists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult innerGet(String type2, String id2, String[] gFields, boolean realtime) throws ElasticSearchException {
        DocumentMapper docMapper;
        boolean loadSource = gFields == null || gFields.length > 0;
        Engine.GetResult get2 = null;
        if (type2 == null || type2.equals("_all")) {
            for (String string2 : this.mapperService.types()) {
                get2 = this.indexShard.get(new Engine.Get(realtime, UidFieldMapper.TERM_FACTORY.createTerm(Uid.createUid(string2, id2))).loadSource(loadSource));
                if (get2.exists()) {
                    type2 = string2;
                    break;
                }
                get2.release();
            }
            if (get2 == null) {
                return new GetResult(this.shardId.index().name(), type2, id2, -1L, false, null, null);
            }
            if (!get2.exists()) {
                return new GetResult(this.shardId.index().name(), type2, id2, -1L, false, null, null);
            }
        } else {
            get2 = this.indexShard.get(new Engine.Get(realtime, UidFieldMapper.TERM_FACTORY.createTerm(Uid.createUid(type2, id2))).loadSource(loadSource));
            if (!get2.exists()) {
                get2.release();
                return new GetResult(this.shardId.index().name(), type2, id2, -1L, false, null, null);
            }
        }
        if ((docMapper = this.mapperService.documentMapper(type2)) == null) {
            get2.release();
            return new GetResult(this.shardId.index().name(), type2, id2, -1L, false, null, null);
        }
        try {
            if (get2.docIdAndVersion() != null) {
                GetResult getResult = this.innerGetLoadFromStoredFields(type2, id2, gFields, get2, docMapper);
                return getResult;
            }
            Translog.Source source2 = get2.source();
            HashMap<String, GetField> fields2 = null;
            boolean sourceRequested = false;
            if (gFields == null) {
                sourceRequested = true;
            } else if (gFields.length == 0) {
                sourceRequested = false;
            } else {
                Map<String, Object> sourceAsMap = null;
                SearchLookup searchLookup = null;
                for (String field2 : gFields) {
                    GetField getField;
                    if (field2.equals("_source")) {
                        sourceRequested = true;
                        continue;
                    }
                    Object value2 = null;
                    if (field2.equals("_routing") && docMapper.routingFieldMapper().stored()) {
                        value2 = source2.routing;
                    } else if (field2.equals("_parent") && docMapper.parentFieldMapper() != null && docMapper.parentFieldMapper().stored()) {
                        value2 = source2.parent;
                    } else if (field2.equals("_timestamp") && docMapper.timestampFieldMapper().stored()) {
                        value2 = source2.timestamp;
                    } else if (field2.equals("_ttl") && docMapper.TTLFieldMapper().stored()) {
                        if (source2.ttl > 0L) {
                            value2 = docMapper.TTLFieldMapper().valueForSearch(source2.timestamp + source2.ttl);
                        }
                    } else if (field2.equals("_size") && docMapper.rootMapper(SizeFieldMapper.class).stored()) {
                        value2 = source2.source.length();
                    } else if (field2.contains("_source.")) {
                        if (searchLookup == null) {
                            searchLookup = new SearchLookup(this.mapperService, this.indexCache.fieldData(), new String[]{type2});
                        }
                        if (sourceAsMap == null) {
                            sourceAsMap = SourceLookup.sourceAsMap(source2.source);
                        }
                        SearchScript searchScript = this.scriptService.search(searchLookup, "mvel", field2, null);
                        searchScript.setNextSource(sourceAsMap);
                        try {
                            value2 = searchScript.run();
                        }
                        catch (RuntimeException e) {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("failed to execute get request script field [{}]", e, field2);
                            }
                        }
                    } else {
                        if (searchLookup == null) {
                            searchLookup = new SearchLookup(this.mapperService, this.indexCache.fieldData(), new String[]{type2});
                            searchLookup.source().setNextSource(source2.source);
                        }
                        FieldMapper x = docMapper.mappers().smartNameFieldMapper(field2);
                        if (docMapper.sourceMapper().enabled() || x == null || x.stored()) {
                            value2 = searchLookup.source().extractValue(field2);
                        }
                    }
                    if (value2 == null) continue;
                    if (fields2 == null) {
                        fields2 = Maps.newHashMapWithExpectedSize(2);
                    }
                    if ((getField = (GetField)fields2.get(field2)) == null) {
                        getField = new GetField(field2, new ArrayList<Object>(2));
                        fields2.put(field2, getField);
                    }
                    getField.values().add(value2);
                }
            }
            if (sourceRequested && !docMapper.sourceMapper().enabled()) {
                sourceRequested = false;
            }
            GetResult getResult = new GetResult(this.shardId.index().name(), type2, id2, get2.version(), get2.exists(), sourceRequested ? source2.source : null, fields2);
            return getResult;
        }
        finally {
            get2.release();
        }
    }

    private GetResult innerGetLoadFromStoredFields(String type2, String id2, String[] gFields, Engine.GetResult get2, DocumentMapper docMapper) {
        Object value2;
        HashMap<String, GetField> fields2 = null;
        byte[] source2 = null;
        UidField.DocIdAndVersion docIdAndVersion = get2.docIdAndVersion();
        ResetFieldSelector fieldSelector = ShardGetService.buildFieldSelectors(docMapper, gFields);
        if (fieldSelector != null) {
            Document doc;
            fieldSelector.reset();
            try {
                doc = docIdAndVersion.reader.document(docIdAndVersion.docId, fieldSelector);
            }
            catch (IOException e) {
                throw new ElasticSearchException("Failed to get type [" + type2 + "] and id [" + id2 + "]", e);
            }
            source2 = ShardGetService.extractSource(doc, docMapper);
            Iterator<Fieldable> i$ = doc.getFields().iterator();
            while (i$.hasNext()) {
                GetField getField;
                FieldMapper mapper;
                Fieldable oField;
                Fieldable field2 = oField = i$.next();
                String name2 = field2.name();
                value2 = null;
                FieldMappers fieldMappers = docMapper.mappers().indexName(field2.name());
                if (fieldMappers != null && (mapper = fieldMappers.mapper()) != null) {
                    name2 = mapper.names().fullName();
                    value2 = mapper.valueForSearch(field2);
                }
                if (value2 == null) {
                    value2 = field2.isBinary() ? new BytesArray(field2.getBinaryValue(), field2.getBinaryOffset(), field2.getBinaryLength()) : field2.stringValue();
                }
                if (fields2 == null) {
                    fields2 = Maps.newHashMapWithExpectedSize(2);
                }
                if ((getField = (GetField)fields2.get(name2)) == null) {
                    getField = new GetField(name2, new ArrayList<Object>(2));
                    fields2.put(name2, getField);
                }
                getField.values().add(value2);
            }
        }
        if (gFields != null && gFields.length > 0) {
            SearchLookup searchLookup = null;
            for (String field3 : gFields) {
                GetField getField;
                value2 = null;
                if (field3.contains("_source.") || field3.contains("doc[")) {
                    if (searchLookup == null) {
                        searchLookup = new SearchLookup(this.mapperService, this.indexCache.fieldData(), new String[]{type2});
                    }
                    SearchScript searchScript = this.scriptService.search(searchLookup, "mvel", field3, null);
                    searchScript.setNextReader(docIdAndVersion.reader);
                    searchScript.setNextDocId(docIdAndVersion.docId);
                    try {
                        value2 = searchScript.run();
                    }
                    catch (RuntimeException e) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("failed to execute get request script field [{}]", e, field3);
                        }
                    }
                } else {
                    FieldMappers x = docMapper.mappers().smartName(field3);
                    if (x == null || !x.mapper().stored()) {
                        if (searchLookup == null) {
                            searchLookup = new SearchLookup(this.mapperService, this.indexCache.fieldData(), new String[]{type2});
                            searchLookup.setNextReader(docIdAndVersion.reader);
                            searchLookup.setNextDocId(docIdAndVersion.docId);
                        }
                        value2 = searchLookup.source().extractValue(field3);
                    }
                }
                if (value2 == null) continue;
                if (fields2 == null) {
                    fields2 = Maps.newHashMapWithExpectedSize(2);
                }
                if ((getField = (GetField)fields2.get(field3)) == null) {
                    getField = new GetField(field3, new ArrayList<Object>(2));
                    fields2.put(field3, getField);
                }
                getField.values().add(value2);
            }
        }
        return new GetResult(this.shardId.index().name(), type2, id2, get2.version(), get2.exists(), source2 == null ? null : new BytesArray(source2), fields2);
    }

    private static ResetFieldSelector buildFieldSelectors(DocumentMapper docMapper, String ... fields2) {
        if (fields2 == null) {
            return docMapper.sourceMapper().fieldSelector();
        }
        if (fields2.length == 0) {
            return null;
        }
        FieldMappersFieldSelector fieldSelector = null;
        for (String fieldName : fields2) {
            FieldMappers x = docMapper.mappers().smartName(fieldName);
            if (x == null || !x.mapper().stored()) continue;
            if (fieldSelector == null) {
                fieldSelector = new FieldMappersFieldSelector();
            }
            fieldSelector.add(x);
        }
        return fieldSelector;
    }

    private static byte[] extractSource(Document doc, DocumentMapper documentMapper) {
        byte[] source2 = null;
        Fieldable sourceField = doc.getFieldable(documentMapper.sourceMapper().names().indexName());
        if (sourceField != null) {
            source2 = documentMapper.sourceMapper().nativeValue(sourceField);
            doc.removeField(documentMapper.sourceMapper().names().indexName());
        }
        return source2;
    }
}

