/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway;

import java.util.concurrent.atomic.AtomicLong;

public class RecoveryStatus {
    private Stage stage = Stage.INIT;
    private long startTime = System.currentTimeMillis();
    private long time;
    private Index index = new Index();
    private Translog translog = new Translog();
    private Start start = new Start();

    public Stage stage() {
        return this.stage;
    }

    public RecoveryStatus updateStage(Stage stage) {
        this.stage = stage;
        return this;
    }

    public long startTime() {
        return this.startTime;
    }

    public void startTime(long startTime) {
        this.startTime = startTime;
    }

    public long time() {
        return this.time;
    }

    public void time(long time) {
        this.time = time;
    }

    public Index index() {
        return this.index;
    }

    public Start start() {
        return this.start;
    }

    public Translog translog() {
        return this.translog;
    }

    public static class Index {
        private long startTime = 0L;
        private long time = 0L;
        private long version = -1L;
        private int numberOfFiles = 0;
        private long totalSize = 0L;
        private int numberOfReusedFiles = 0;
        private long reusedTotalSize = 0L;
        private AtomicLong currentFilesSize = new AtomicLong();

        public long startTime() {
            return this.startTime;
        }

        public void startTime(long startTime) {
            this.startTime = startTime;
        }

        public long time() {
            return this.time;
        }

        public void time(long time) {
            this.time = time;
        }

        public long version() {
            return this.version;
        }

        public void files(int numberOfFiles, long totalSize, int numberOfReusedFiles, long reusedTotalSize) {
            this.numberOfFiles = numberOfFiles;
            this.totalSize = totalSize;
            this.numberOfReusedFiles = numberOfReusedFiles;
            this.reusedTotalSize = reusedTotalSize;
        }

        public int numberOfFiles() {
            return this.numberOfFiles;
        }

        public int numberOfRecoveredFiles() {
            return this.numberOfFiles - this.numberOfReusedFiles;
        }

        public long totalSize() {
            return this.totalSize;
        }

        public int numberOfReusedFiles() {
            return this.numberOfReusedFiles;
        }

        public long reusedTotalSize() {
            return this.reusedTotalSize;
        }

        public long recoveredTotalSize() {
            return this.totalSize - this.reusedTotalSize;
        }

        public void updateVersion(long version) {
            this.version = version;
        }

        public long currentFilesSize() {
            return this.currentFilesSize.get();
        }

        public void addCurrentFilesSize(long updatedSize) {
            this.currentFilesSize.addAndGet(updatedSize);
        }
    }

    public static class Translog {
        private long startTime = 0L;
        private long time;
        private volatile int currentTranslogOperations = 0;

        public long startTime() {
            return this.startTime;
        }

        public void startTime(long startTime) {
            this.startTime = startTime;
        }

        public long time() {
            return this.time;
        }

        public void time(long time) {
            this.time = time;
        }

        public void addTranslogOperations(int count2) {
            this.currentTranslogOperations += count2;
        }

        public int currentTranslogOperations() {
            return this.currentTranslogOperations;
        }
    }

    public static class Start {
        private long startTime;
        private long time;
        private long checkIndexTime;

        public long startTime() {
            return this.startTime;
        }

        public void startTime(long startTime) {
            this.startTime = startTime;
        }

        public long time() {
            return this.time;
        }

        public void time(long time) {
            this.time = time;
        }

        public long checkIndexTime() {
            return this.checkIndexTime;
        }

        public void checkIndexTime(long checkIndexTime) {
            this.checkIndexTime = checkIndexTime;
        }
    }

    public static enum Stage {
        INIT,
        INDEX,
        START,
        TRANSLOG,
        DONE;

    }
}

