/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.gateway.CommitPoint;

public class CommitPoints
implements Iterable<CommitPoint> {
    private final ImmutableList<CommitPoint> commitPoints;

    public CommitPoints(List<CommitPoint> commitPoints) {
        Collections.sort(commitPoints, new Comparator<CommitPoint>(){

            @Override
            public int compare(CommitPoint o1, CommitPoint o2) {
                return o2.version() < o1.version() ? -1 : (o2.version() == o1.version() ? 0 : 1);
            }
        });
        this.commitPoints = ImmutableList.copyOf(commitPoints);
    }

    public ImmutableList<CommitPoint> commits() {
        return this.commitPoints;
    }

    public boolean hasVersion(long version) {
        for (CommitPoint commitPoint : this.commitPoints) {
            if (commitPoint.version() != version) continue;
            return true;
        }
        return false;
    }

    public CommitPoint.FileInfo findPhysicalIndexFile(String physicalName) {
        for (CommitPoint commitPoint : this.commitPoints) {
            CommitPoint.FileInfo fileInfo = commitPoint.findPhysicalIndexFile(physicalName);
            if (fileInfo == null) continue;
            return fileInfo;
        }
        return null;
    }

    public CommitPoint.FileInfo findNameFile(String name2) {
        for (CommitPoint commitPoint : this.commitPoints) {
            CommitPoint.FileInfo fileInfo = commitPoint.findNameFile(name2);
            if (fileInfo == null) continue;
            return fileInfo;
        }
        return null;
    }

    @Override
    public Iterator<CommitPoint> iterator() {
        return this.commitPoints.iterator();
    }

    public static byte[] toXContent(CommitPoint commitPoint) throws Exception {
        XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON).prettyPrint();
        builder.startObject();
        builder.field("version", commitPoint.version());
        builder.field("name", commitPoint.name());
        builder.field("type", commitPoint.type().toString());
        builder.startObject("index_files");
        for (CommitPoint.FileInfo fileInfo : commitPoint.indexFiles()) {
            builder.startObject(fileInfo.name());
            builder.field("physical_name", fileInfo.physicalName());
            builder.field("length", fileInfo.length());
            if (fileInfo.checksum() != null) {
                builder.field("checksum", fileInfo.checksum());
            }
            builder.endObject();
        }
        builder.endObject();
        builder.startObject("translog_files");
        for (CommitPoint.FileInfo fileInfo : commitPoint.translogFiles()) {
            builder.startObject(fileInfo.name());
            builder.field("physical_name", fileInfo.physicalName());
            builder.field("length", fileInfo.length());
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder.bytes().toBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommitPoint fromXContent(byte[] data2) throws Exception {
        XContentParser parser = XContentFactory.xContent(XContentType.JSON).createParser(data2);
        try {
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            if (token == null) {
                throw new IOException("No commit point data");
            }
            long version = -1L;
            String name2 = null;
            CommitPoint.Type type2 = null;
            ArrayList<CommitPoint.FileInfo> indexFiles = Lists.newArrayList();
            ArrayList<CommitPoint.FileInfo> translogFiles = Lists.newArrayList();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    ArrayList<CommitPoint.FileInfo> files = null;
                    if ("index_files".equals(currentFieldName) || "indexFiles".equals(currentFieldName)) {
                        files = indexFiles;
                    } else if ("translog_files".equals(currentFieldName) || "translogFiles".equals(currentFieldName)) {
                        files = translogFiles;
                    } else {
                        throw new IOException("Can't handle object with name [" + currentFieldName + "]");
                    }
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token != XContentParser.Token.START_OBJECT) continue;
                        String fileName = currentFieldName;
                        String physicalName = null;
                        long size2 = -1L;
                        String checksum = null;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (!token.isValue()) continue;
                            if ("physical_name".equals(currentFieldName) || "physicalName".equals(currentFieldName)) {
                                physicalName = parser.text();
                                continue;
                            }
                            if ("length".equals(currentFieldName)) {
                                size2 = parser.longValue();
                                continue;
                            }
                            if (!"checksum".equals(currentFieldName)) continue;
                            checksum = parser.text();
                        }
                        if (physicalName == null) {
                            throw new IOException("Malformed commit, missing physical_name for [" + fileName + "]");
                        }
                        if (size2 == -1L) {
                            throw new IOException("Malformed commit, missing length for [" + fileName + "]");
                        }
                        files.add(new CommitPoint.FileInfo(fileName, physicalName, size2, checksum));
                    }
                    continue;
                }
                if (!token.isValue()) continue;
                if ("version".equals(currentFieldName)) {
                    version = parser.longValue();
                    continue;
                }
                if ("name".equals(currentFieldName)) {
                    name2 = parser.text();
                    continue;
                }
                if (!"type".equals(currentFieldName)) continue;
                type2 = CommitPoint.Type.valueOf(parser.text());
            }
            if (version == -1L) {
                throw new IOException("Malformed commit, missing version");
            }
            if (name2 == null) {
                throw new IOException("Malformed commit, missing name");
            }
            if (type2 == null) {
                throw new IOException("Malformed commit, missing type");
            }
            CommitPoint commitPoint = new CommitPoint(version, name2, type2, indexFiles, translogFiles);
            return commitPoint;
        }
        finally {
            parser.close();
        }
    }
}

