/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.support;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.index.field.data.FieldData;

public class FieldDataLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends FieldData> T load(IndexReader reader, String field2, TypeLoader<T> loader) throws IOException {
        ArrayList<int[]> ordinals;
        block15: {
            loader.init();
            field2 = StringHelper.intern(field2);
            ordinals = new ArrayList<int[]>();
            int[] idx = new int[reader.maxDoc()];
            ordinals.add(new int[reader.maxDoc()]);
            int t = 1;
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field2));
            try {
                Term term;
                int size2 = Math.min(128, reader.maxDoc());
                int[] docs = new int[size2];
                int[] freqs = new int[size2];
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field2) {
                    } else {
                        loader.collectTerm(term.text());
                        termDocs.seek(termEnum);
                        int number = termDocs.read(docs, freqs);
                        while (number > 0) {
                            for (int i2 = 0; i2 < number; ++i2) {
                                int[] ordinal;
                                int doc = docs[i2];
                                if (idx[doc] >= ordinals.size()) {
                                    ordinal = new int[reader.maxDoc()];
                                    ordinals.add(ordinal);
                                } else {
                                    ordinal = (int[])ordinals.get(idx[doc]);
                                }
                                ordinal[doc] = t;
                                int n = doc;
                                idx[n] = idx[n] + 1;
                            }
                            number = termDocs.read(docs, freqs);
                        }
                        ++t;
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            catch (RuntimeException e) {
                if (e.getClass().getName().endsWith("StopFillCacheException")) {
                    break block15;
                }
                throw e;
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
        }
        if (ordinals.size() == 1) {
            return loader.buildSingleValue(field2, (int[])ordinals.get(0));
        }
        int[][] nativeOrdinals = new int[ordinals.size()][];
        for (int i3 = 0; i3 < nativeOrdinals.length; ++i3) {
            nativeOrdinals[i3] = (int[])ordinals.get(i3);
        }
        return loader.buildMultiValue(field2, nativeOrdinals);
    }

    public static abstract class FreqsTypeLoader<T extends FieldData>
    implements TypeLoader<T> {
        protected FreqsTypeLoader() {
        }

        @Override
        public void init() {
        }
    }

    public static interface TypeLoader<T extends FieldData> {
        public void init();

        public void collectTerm(String var1);

        public T buildSingleValue(String var1, int[] var2);

        public T buildMultiValue(String var1, int[][] var2);
    }
}

