/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.strings;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.strings.MultiValueStringFieldData;
import org.elasticsearch.index.field.data.strings.SingleValueStringFieldData;
import org.elasticsearch.index.field.data.strings.StringDocFieldData;
import org.elasticsearch.index.field.data.support.FieldDataLoader;

public abstract class StringFieldData
extends FieldData<StringDocFieldData> {
    protected final String[] values;

    protected StringFieldData(String fieldName, String[] values2) {
        super(fieldName);
        this.values = values2;
    }

    @Override
    protected long computeSizeInBytes() {
        long size2 = RamUsage.NUM_BYTES_ARRAY_HEADER;
        for (String value2 : this.values) {
            if (value2 == null) continue;
            size2 += (long)(8 + (value2.length() * 2 + 12));
        }
        return size2;
    }

    public String[] values() {
        return this.values;
    }

    public abstract String value(int var1);

    public abstract String[] values(int var1);

    @Override
    public StringDocFieldData docFieldData(int docId) {
        return (StringDocFieldData)super.docFieldData(docId);
    }

    @Override
    public String stringValue(int docId) {
        return this.value(docId);
    }

    @Override
    protected StringDocFieldData createFieldData() {
        return new StringDocFieldData(this);
    }

    @Override
    public FieldDataType type() {
        return FieldDataType.DefaultTypes.STRING;
    }

    @Override
    public void forEachValue(FieldData.StringValueProc proc2) {
        for (int i2 = 1; i2 < this.values.length; ++i2) {
            proc2.onValue(this.values[i2]);
        }
    }

    public static StringFieldData load(IndexReader reader, String field2) throws IOException {
        return FieldDataLoader.load(reader, field2, new StringTypeLoader());
    }

    static class StringTypeLoader
    extends FieldDataLoader.FreqsTypeLoader<StringFieldData> {
        private final ArrayList<String> terms = new ArrayList();

        StringTypeLoader() {
            this.terms.add(null);
        }

        @Override
        public void collectTerm(String term) {
            this.terms.add(term);
        }

        @Override
        public StringFieldData buildSingleValue(String field2, int[] ordinals) {
            return new SingleValueStringFieldData(field2, ordinals, this.terms.toArray(new String[this.terms.size()]));
        }

        @Override
        public StringFieldData buildMultiValue(String field2, int[][] ordinals) {
            return new MultiValueStringFieldData(field2, ordinals, this.terms.toArray(new String[this.terms.size()]));
        }
    }
}

