/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.deletionpolicy;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;

public class KeepLastNDeletionPolicy
extends AbstractIndexShardComponent
implements IndexDeletionPolicy {
    private final int numToKeep;

    @Inject
    public KeepLastNDeletionPolicy(ShardId shardId, @IndexSettings Settings indexSettings) {
        super(shardId, indexSettings);
        this.numToKeep = this.componentSettings.getAsInt("num_to_keep", 5);
        this.logger.debug("Using [keep_last_n] deletion policy with num_to_keep[{}]", this.numToKeep);
    }

    @Override
    public void onInit(List<? extends IndexCommit> commits) throws IOException {
        this.doDeletes(commits);
    }

    @Override
    public void onCommit(List<? extends IndexCommit> commits) throws IOException {
        this.doDeletes(commits);
    }

    private void doDeletes(List<? extends IndexCommit> commits) {
        int size2 = commits.size();
        for (int i2 = 0; i2 < size2 - this.numToKeep; ++i2) {
            commits.get(i2).delete();
        }
    }
}

