/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.field.data.resident;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.field.data.support.AbstractConcurrentMapFieldDataCache;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;

public class ResidentFieldDataCache
extends AbstractConcurrentMapFieldDataCache
implements RemovalListener<String, FieldData> {
    private final IndexSettingsService indexSettingsService;
    private volatile int maxSize;
    private volatile TimeValue expire;
    private final CounterMetric evictions = new CounterMetric();
    private final ApplySettings applySettings = new ApplySettings();
    public static final String INDEX_CACHE_FIELD_MAX_SIZE = "index.cache.field.max_size";
    public static final String INDEX_CACHE_FIELD_EXPIRE = "index.cache.field.expire";

    @Inject
    public ResidentFieldDataCache(Index index2, @IndexSettings Settings indexSettings, IndexSettingsService indexSettingsService) {
        super(index2, indexSettings);
        this.indexSettingsService = indexSettingsService;
        this.maxSize = indexSettings.getAsInt(INDEX_CACHE_FIELD_MAX_SIZE, this.componentSettings.getAsInt("max_size", -1));
        this.expire = indexSettings.getAsTime(INDEX_CACHE_FIELD_EXPIRE, this.componentSettings.getAsTime("expire", null));
        this.logger.debug("using [resident] field cache with max_size [{}], expire [{}]", this.maxSize, this.expire);
        indexSettingsService.addListener(this.applySettings);
    }

    @Override
    public void close() throws ElasticSearchException {
        this.indexSettingsService.removeListener(this.applySettings);
        super.close();
    }

    @Override
    protected Cache<String, FieldData> buildFieldDataMap() {
        CacheBuilder<String, FieldData> cacheBuilder = CacheBuilder.newBuilder().removalListener(this);
        if (this.maxSize != -1) {
            cacheBuilder.maximumSize(this.maxSize);
        }
        if (this.expire != null) {
            cacheBuilder.expireAfterAccess(this.expire.nanos(), TimeUnit.NANOSECONDS);
        }
        return cacheBuilder.build();
    }

    @Override
    public String type() {
        return "resident";
    }

    @Override
    public long evictions() {
        return this.evictions.count();
    }

    @Override
    public void onRemoval(RemovalNotification<String, FieldData> removalNotification) {
        if (removalNotification.wasEvicted()) {
            this.evictions.inc();
        }
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            int maxSize = settings.getAsInt(ResidentFieldDataCache.INDEX_CACHE_FIELD_MAX_SIZE, ResidentFieldDataCache.this.maxSize);
            TimeValue expire = settings.getAsTime(ResidentFieldDataCache.INDEX_CACHE_FIELD_EXPIRE, ResidentFieldDataCache.this.expire);
            boolean changed = false;
            if (maxSize != ResidentFieldDataCache.this.maxSize) {
                ResidentFieldDataCache.this.logger.info("updating index.cache.field.max_size from [{}] to [{}]", ResidentFieldDataCache.this.maxSize, maxSize);
                changed = true;
                ResidentFieldDataCache.this.maxSize = maxSize;
            }
            if (!Objects.equal(expire, ResidentFieldDataCache.this.expire)) {
                ResidentFieldDataCache.this.logger.info("updating index.cache.field.expire from [{}] to [{}]", ResidentFieldDataCache.this.expire, expire);
                changed = true;
                ResidentFieldDataCache.this.expire = expire;
            }
            if (changed) {
                ResidentFieldDataCache.this.clear("update_settings");
            }
        }
    }
}

