/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache;

import org.apache.lucene.index.IndexReader;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.CloseableComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.CacheStats;
import org.elasticsearch.index.cache.bloom.BloomCache;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.cache.filter.FilterCache;
import org.elasticsearch.index.cache.id.IdCache;
import org.elasticsearch.index.cache.query.parser.QueryParserCache;
import org.elasticsearch.index.settings.IndexSettings;

public class IndexCache
extends AbstractIndexComponent
implements CloseableComponent,
ClusterStateListener {
    private final FilterCache filterCache;
    private final FieldDataCache fieldDataCache;
    private final QueryParserCache queryParserCache;
    private final IdCache idCache;
    private final BloomCache bloomCache;
    private final TimeValue refreshInterval;
    private ClusterService clusterService;
    private long latestCacheStatsTimestamp = -1L;
    private CacheStats latestCacheStats;

    @Inject
    public IndexCache(Index index2, @IndexSettings Settings indexSettings, FilterCache filterCache, FieldDataCache fieldDataCache, QueryParserCache queryParserCache, IdCache idCache, BloomCache bloomCache) {
        super(index2, indexSettings);
        this.filterCache = filterCache;
        this.fieldDataCache = fieldDataCache;
        this.queryParserCache = queryParserCache;
        this.idCache = idCache;
        this.bloomCache = bloomCache;
        this.refreshInterval = this.componentSettings.getAsTime("stats.refresh_interval", TimeValue.timeValueSeconds(1L));
        this.logger.debug("Using stats.refresh_interval [{}]", this.refreshInterval);
    }

    @Inject(optional=true)
    public void setClusterService(@Nullable ClusterService clusterService) {
        this.clusterService = clusterService;
        if (clusterService != null) {
            clusterService.add(this);
        }
    }

    public synchronized void invalidateCache() {
        FilterCache.EntriesStats filterEntriesStats = this.filterCache.entriesStats();
        this.latestCacheStats = new CacheStats(this.fieldDataCache.evictions(), this.filterCache.evictions(), this.fieldDataCache.sizeInBytes(), filterEntriesStats.sizeInBytes, filterEntriesStats.count, this.bloomCache.sizeInBytes(), this.idCache.sizeInBytes());
        this.latestCacheStatsTimestamp = System.currentTimeMillis();
    }

    public synchronized CacheStats stats() {
        long timestamp = System.currentTimeMillis();
        if (timestamp - this.latestCacheStatsTimestamp > this.refreshInterval.millis()) {
            FilterCache.EntriesStats filterEntriesStats = this.filterCache.entriesStats();
            this.latestCacheStats = new CacheStats(this.fieldDataCache.evictions(), this.filterCache.evictions(), this.fieldDataCache.sizeInBytes(), filterEntriesStats.sizeInBytes, filterEntriesStats.count, this.bloomCache.sizeInBytes(), this.idCache.sizeInBytes());
            this.latestCacheStatsTimestamp = timestamp;
        }
        return this.latestCacheStats;
    }

    public FilterCache filter() {
        return this.filterCache;
    }

    public FieldDataCache fieldData() {
        return this.fieldDataCache;
    }

    public IdCache idCache() {
        return this.idCache;
    }

    public BloomCache bloomCache() {
        return this.bloomCache;
    }

    public QueryParserCache queryParserCache() {
        return this.queryParserCache;
    }

    @Override
    public void close() throws ElasticSearchException {
        this.filterCache.close();
        this.fieldDataCache.close();
        this.idCache.close();
        this.queryParserCache.close();
        this.bloomCache.close();
        if (this.clusterService != null) {
            this.clusterService.remove(this);
        }
    }

    public void clear(IndexReader reader) {
        this.filterCache.clear(reader);
        this.fieldDataCache.clear(reader);
        this.idCache.clear(reader);
        this.bloomCache.clear(reader);
    }

    public void clear(String reason2) {
        this.filterCache.clear(reason2);
        this.fieldDataCache.clear(reason2);
        this.idCache.clear();
        this.queryParserCache.clear();
        this.bloomCache.clear();
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.metaDataChanged()) {
            this.queryParserCache.clear();
        }
    }
}

