/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.TrimFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class TrimTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final boolean updateOffsets;

    @Inject
    public TrimTokenFilterFactory(Index index2, @IndexSettings Settings indexSettings, Environment env, @Assisted String name2, @Assisted Settings settings) {
        super(index2, indexSettings, name2, settings);
        this.updateOffsets = settings.getAsBoolean("update_offsets", false);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new TrimFilter(tokenStream, this.updateOffsets);
    }
}

