/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.StemmerOverrideFilter;
import org.apache.lucene.util.Version;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.analysis.AnalysisSettingsRequired;
import org.elasticsearch.index.settings.IndexSettings;

@AnalysisSettingsRequired
public class StemmerOverrideTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final Map<String, String> dictionary;

    @Inject
    public StemmerOverrideTokenFilterFactory(Index index2, @IndexSettings Settings indexSettings, Environment env, @Assisted String name2, @Assisted Settings settings) {
        super(index2, indexSettings, name2, settings);
        List<String> rules = Analysis.getWordList(env, settings, "rules");
        if (rules == null) {
            throw new ElasticSearchIllegalArgumentException("stemmer override filter requires either `rules` or `rules_path` to be configured");
        }
        this.dictionary = new HashMap<String, String>();
        StemmerOverrideTokenFilterFactory.parseRules(rules, this.dictionary, "=>");
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new StemmerOverrideFilter(Version.LUCENE_32, tokenStream, this.dictionary);
    }

    static void parseRules(List<String> rules, Map<String, String> rulesMap, String mappingSep) {
        for (String rule : rules) {
            List<String> mapping = Strings.splitSmart(rule, mappingSep, false);
            if (mapping.size() != 2) {
                throw new RuntimeException("Invalid Keyword override Rule:" + rule);
            }
            String key2 = mapping.get(0).trim();
            String override = mapping.get(1).trim();
            if (key2.isEmpty() || override.isEmpty()) {
                throw new RuntimeException("Invalid Keyword override Rule:" + rule);
            }
            rulesMap.put(key2, override);
        }
    }
}

