/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.regex.Pattern;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.pattern.PatternReplaceFilter;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.AnalysisSettingsRequired;
import org.elasticsearch.index.settings.IndexSettings;

@AnalysisSettingsRequired
public class PatternReplaceTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final Pattern pattern;
    private final String replacement;
    private final boolean all;

    @Inject
    public PatternReplaceTokenFilterFactory(Index index2, @IndexSettings Settings indexSettings, @Assisted String name2, @Assisted Settings settings) {
        super(index2, indexSettings, name2, settings);
        String sPattern = settings.get("pattern", null);
        if (sPattern == null) {
            throw new ElasticSearchIllegalArgumentException("pattern is missing for [" + name2 + "] token filter of type 'pattern_replace'");
        }
        this.pattern = Regex.compile(sPattern, settings.get("flags"));
        String sReplacement = settings.get("replacement", null);
        if (sReplacement == null) {
            throw new ElasticSearchIllegalArgumentException("replacement is missing for [" + name2 + "] token filter of type 'pattern_replace'");
        }
        this.replacement = sReplacement;
        this.all = settings.getAsBoolean("all", true);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new PatternReplaceFilter(tokenStream, this.pattern, this.replacement, this.all);
    }
}

