/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.index.analysis.AnalyzerScope;

public class NamedAnalyzer
extends Analyzer {
    private final String name;
    private final AnalyzerScope scope;
    private final Analyzer analyzer;

    public NamedAnalyzer(String name2, Analyzer analyzer) {
        this(name2, AnalyzerScope.INDEX, analyzer);
    }

    public NamedAnalyzer(String name2, AnalyzerScope scope, Analyzer analyzer) {
        this.name = name2;
        this.scope = scope;
        this.analyzer = analyzer;
    }

    public String name() {
        return this.name;
    }

    public AnalyzerScope scope() {
        return this.scope;
    }

    public Analyzer analyzer() {
        return this.analyzer;
    }

    @Override
    public final TokenStream tokenStream(String fieldName, Reader reader) {
        return this.analyzer.tokenStream(fieldName, reader);
    }

    @Override
    public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        return this.analyzer.reusableTokenStream(fieldName, reader);
    }

    @Override
    public int getPositionIncrementGap(String fieldName) {
        return this.analyzer.getPositionIncrementGap(fieldName);
    }

    @Override
    public int getOffsetGap(Fieldable field2) {
        return this.analyzer.getOffsetGap(field2);
    }

    @Override
    public void close() {
        this.analyzer.close();
    }

    public String toString() {
        return "analyzer name[" + this.name + "], analyzer [" + this.analyzer + "]";
    }
}

