/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class EdgeNGramTokenizerFactory
extends AbstractTokenizerFactory {
    private final int minGram;
    private final int maxGram;
    private final EdgeNGramTokenizer.Side side;

    @Inject
    public EdgeNGramTokenizerFactory(Index index2, @IndexSettings Settings indexSettings, @Assisted String name2, @Assisted Settings settings) {
        super(index2, indexSettings, name2, settings);
        this.minGram = settings.getAsInt("min_gram", 1);
        this.maxGram = settings.getAsInt("max_gram", 2);
        this.side = EdgeNGramTokenizer.Side.getSide(settings.get("side", EdgeNGramTokenizer.DEFAULT_SIDE.getLabel()));
    }

    @Override
    public Tokenizer create(Reader reader) {
        return new EdgeNGramTokenizer(reader, this.side, this.minGram, this.maxGram);
    }
}

