/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.aliases;

import java.io.IOException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilterClause;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.aliases.IndexAlias;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.AliasFilterParsingException;
import org.elasticsearch.indices.InvalidAliasNameException;

public class IndexAliasesService
extends AbstractIndexComponent
implements Iterable<IndexAlias> {
    private final IndexQueryParserService indexQueryParser;
    private volatile ImmutableMap<String, IndexAlias> aliases = ImmutableMap.of();
    private final Object mutex = new Object();

    @Inject
    public IndexAliasesService(Index index2, @IndexSettings Settings indexSettings, IndexQueryParserService indexQueryParser) {
        super(index2, indexSettings);
        this.indexQueryParser = indexQueryParser;
    }

    public boolean hasAlias(String alias2) {
        return this.aliases.containsKey(alias2);
    }

    public IndexAlias alias(String alias2) {
        return this.aliases.get(alias2);
    }

    public void add(String alias2, @Nullable CompressedString filter) {
        this.add(new IndexAlias(alias2, filter, this.parse(alias2, filter)));
    }

    public Filter aliasFilter(String ... aliases2) {
        if (aliases2 == null || aliases2.length == 0) {
            return null;
        }
        if (aliases2.length == 1) {
            IndexAlias indexAlias = this.alias(aliases2[0]);
            if (indexAlias == null) {
                throw new InvalidAliasNameException(this.index, aliases2[0], "Unknown alias name was passed to alias Filter");
            }
            return indexAlias.parsedFilter();
        }
        XBooleanFilter combined = new XBooleanFilter();
        for (String alias2 : aliases2) {
            IndexAlias indexAlias = this.alias(alias2);
            if (indexAlias == null) {
                throw new InvalidAliasNameException(this.index, aliases2[0], "Unknown alias name was passed to alias Filter");
            }
            if (indexAlias.parsedFilter() == null) {
                return null;
            }
            combined.add(new FilterClause(indexAlias.parsedFilter(), BooleanClause.Occur.SHOULD));
        }
        if (combined.getShouldFilters().size() == 0) {
            return null;
        }
        if (combined.getShouldFilters().size() == 1) {
            return combined.getShouldFilters().get(0);
        }
        return combined;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(IndexAlias indexAlias) {
        Object object = this.mutex;
        synchronized (object) {
            this.aliases = MapBuilder.newMapBuilder(this.aliases).put(indexAlias.alias(), indexAlias).immutableMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String alias2) {
        Object object = this.mutex;
        synchronized (object) {
            this.aliases = MapBuilder.newMapBuilder(this.aliases).remove(alias2).immutableMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Filter parse(String alias2, CompressedString filter) {
        if (filter == null) {
            return null;
        }
        byte[] filterSource = filter.uncompressed();
        XContentParser parser = XContentFactory.xContent(filterSource).createParser(filterSource);
        try {
            Filter filter2 = this.indexQueryParser.parseInnerFilter(parser);
            parser.close();
            return filter2;
        }
        catch (Throwable throwable) {
            try {
                parser.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new AliasFilterParsingException(this.index, alias2, "Invalid alias filter", (Throwable)ex);
            }
        }
    }

    @Override
    public UnmodifiableIterator<IndexAlias> iterator() {
        return ((ImmutableCollection)this.aliases.values()).iterator();
    }
}

