/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.NativeFSLockFactory;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.primitives.Ints;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;

public class NodeEnvironment
extends AbstractComponent {
    private final File[] nodeFiles;
    private final File[] nodeIndicesLocations;
    private final Lock[] locks;
    private final int localNodeId;

    @Inject
    public NodeEnvironment(Settings settings, Environment environment) {
        super(settings);
        if (!DiscoveryNode.nodeRequiresLocalStorage(settings)) {
            this.nodeFiles = null;
            this.nodeIndicesLocations = null;
            this.locks = null;
            this.localNodeId = -1;
            return;
        }
        File[] nodesFiles = new File[environment.dataWithClusterFiles().length];
        Lock[] locks = new Lock[environment.dataWithClusterFiles().length];
        int localNodeId = -1;
        IOException lastException = null;
        int maxLocalStorageNodes = settings.getAsInt("node.max_local_storage_nodes", 50);
        for (int possibleLockId = 0; possibleLockId < maxLocalStorageNodes; ++possibleLockId) {
            for (int dirIndex = 0; dirIndex < environment.dataWithClusterFiles().length; ++dirIndex) {
                File dir = new File(new File(environment.dataWithClusterFiles()[dirIndex], "nodes"), Integer.toString(possibleLockId));
                if (!dir.exists()) {
                    FileSystemUtils.mkdirs(dir);
                }
                this.logger.trace("obtaining node lock on {} ...", dir.getAbsolutePath());
                try {
                    NativeFSLockFactory lockFactory = new NativeFSLockFactory(dir);
                    Lock tmpLock = lockFactory.makeLock("node.lock");
                    boolean obtained = tmpLock.obtain();
                    if (obtained) {
                        locks[dirIndex] = tmpLock;
                        nodesFiles[dirIndex] = dir;
                        localNodeId = possibleLockId;
                        continue;
                    }
                    this.logger.trace("failed to obtain node lock on {}", dir.getAbsolutePath());
                    for (int i2 = 0; i2 < locks.length; ++i2) {
                        if (locks[i2] != null) {
                            try {
                                locks[i2].release();
                            }
                            catch (Exception e1) {
                                // empty catch block
                            }
                        }
                        locks[i2] = null;
                    }
                    break;
                }
                catch (IOException e) {
                    this.logger.trace("failed to obtain node lock on {}", e, dir.getAbsolutePath());
                    lastException = new IOException("failed to obtain lock on " + dir.getAbsolutePath(), e);
                    for (int i3 = 0; i3 < locks.length; ++i3) {
                        if (locks[i3] != null) {
                            try {
                                locks[i3].release();
                            }
                            catch (Exception e1) {
                                // empty catch block
                            }
                        }
                        locks[i3] = null;
                    }
                    break;
                }
            }
            if (locks[0] != null) break;
        }
        if (locks[0] == null) {
            throw new ElasticSearchIllegalStateException("Failed to obtain node lock, is the following location writable?: " + Arrays.toString(environment.dataWithClusterFiles()), lastException);
        }
        this.localNodeId = localNodeId;
        this.locks = locks;
        this.nodeFiles = nodesFiles;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("using node location [{}], local_node_id [{}]", nodesFiles, localNodeId);
        }
        if (this.logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder("node data locations details:\n");
            for (File file2 : nodesFiles) {
                sb.append(" -> ").append(file2.getAbsolutePath()).append(", free_space [").append(new ByteSizeValue(file2.getFreeSpace())).append("], usable_space [").append(new ByteSizeValue(file2.getUsableSpace())).append("]\n");
            }
            this.logger.trace(sb.toString(), new Object[0]);
        }
        this.nodeIndicesLocations = new File[this.nodeFiles.length];
        for (int i4 = 0; i4 < this.nodeFiles.length; ++i4) {
            this.nodeIndicesLocations[i4] = new File(this.nodeFiles[i4], "indices");
        }
    }

    public int localNodeId() {
        return this.localNodeId;
    }

    public boolean hasNodeFile() {
        return this.nodeFiles != null && this.locks != null;
    }

    public File[] nodeDataLocations() {
        if (this.nodeFiles == null || this.locks == null) {
            throw new ElasticSearchIllegalStateException("node is not configured to store local location");
        }
        return this.nodeFiles;
    }

    public File[] indicesLocations() {
        return this.nodeIndicesLocations;
    }

    public File[] indexLocations(Index index2) {
        File[] indexLocations = new File[this.nodeFiles.length];
        for (int i2 = 0; i2 < this.nodeFiles.length; ++i2) {
            indexLocations[i2] = new File(new File(this.nodeFiles[i2], "indices"), index2.name());
        }
        return indexLocations;
    }

    public File[] shardLocations(ShardId shardId) {
        File[] shardLocations = new File[this.nodeFiles.length];
        for (int i2 = 0; i2 < this.nodeFiles.length; ++i2) {
            shardLocations[i2] = new File(new File(new File(this.nodeFiles[i2], "indices"), shardId.index().name()), Integer.toString(shardId.id()));
        }
        return shardLocations;
    }

    public Set<String> findAllIndices() throws Exception {
        if (this.nodeFiles == null || this.locks == null) {
            throw new ElasticSearchIllegalStateException("node is not configured to store local location");
        }
        HashSet<String> indices2 = Sets.newHashSet();
        for (File indicesLocation : this.nodeIndicesLocations) {
            File[] indicesList = indicesLocation.listFiles();
            if (indicesList == null) continue;
            for (File indexLocation : indicesList) {
                if (!indexLocation.isDirectory()) continue;
                indices2.add(indexLocation.getName());
            }
        }
        return indices2;
    }

    public Set<ShardId> findAllShardIds() throws Exception {
        if (this.nodeFiles == null || this.locks == null) {
            throw new ElasticSearchIllegalStateException("node is not configured to store local location");
        }
        HashSet<ShardId> shardIds = Sets.newHashSet();
        for (File indicesLocation : this.nodeIndicesLocations) {
            File[] indicesList = indicesLocation.listFiles();
            if (indicesList == null) continue;
            for (File indexLocation : indicesList) {
                if (!indexLocation.isDirectory()) continue;
                String indexName = indexLocation.getName();
                File[] shardsList = indexLocation.listFiles();
                if (shardsList == null) continue;
                for (File shardLocation : shardsList) {
                    Integer shardId;
                    if (!shardLocation.isDirectory() || (shardId = Ints.tryParse(shardLocation.getName())) == null) continue;
                    shardIds.add(new ShardId(indexName, (int)shardId));
                }
            }
        }
        return shardIds;
    }

    public void close() {
        if (this.locks != null) {
            for (Lock lock2 : this.locks) {
                try {
                    lock2.release();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }
}

