/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.unit.TimeValue;

public class XContentMapValues {
    public static List<Object> extractRawValues(String path2, Map<String, Object> map) {
        ArrayList<Object> values2 = Lists.newArrayList();
        String[] pathElements = Strings.splitStringToArray(path2, '.');
        if (pathElements.length == 0) {
            return values2;
        }
        XContentMapValues.extractRawValues(values2, map, pathElements, 0);
        return values2;
    }

    private static void extractRawValues(List values2, Map<String, Object> part, String[] pathElements, int index2) {
        int nextIndex;
        if (index2 == pathElements.length) {
            return;
        }
        String key2 = pathElements[index2];
        Object currentValue = part.get(key2);
        for (nextIndex = index2 + 1; currentValue == null && nextIndex != pathElements.length; ++nextIndex) {
            key2 = key2 + "." + pathElements[nextIndex];
            currentValue = part.get(key2);
        }
        if (currentValue == null) {
            return;
        }
        if (currentValue instanceof Map) {
            XContentMapValues.extractRawValues(values2, (Map)currentValue, pathElements, nextIndex);
        } else if (currentValue instanceof List) {
            XContentMapValues.extractRawValues(values2, (List)currentValue, pathElements, nextIndex);
        } else {
            values2.add(currentValue);
        }
    }

    private static void extractRawValues(List values2, List<Object> part, String[] pathElements, int index2) {
        for (Object value2 : part) {
            if (value2 == null) continue;
            if (value2 instanceof Map) {
                XContentMapValues.extractRawValues(values2, (Map)value2, pathElements, index2);
                continue;
            }
            if (value2 instanceof List) {
                XContentMapValues.extractRawValues(values2, (List)value2, pathElements, index2);
                continue;
            }
            values2.add(value2);
        }
    }

    public static Object extractValue(String path2, Map<String, Object> map) {
        String[] pathElements = Strings.splitStringToArray(path2, '.');
        if (pathElements.length == 0) {
            return null;
        }
        return XContentMapValues.extractValue(pathElements, 0, map);
    }

    private static Object extractValue(String[] pathElements, int index2, Object currentValue) {
        if (index2 == pathElements.length) {
            return currentValue;
        }
        if (currentValue == null) {
            return null;
        }
        if (currentValue instanceof Map) {
            int nextIndex;
            Map map = (Map)currentValue;
            String key2 = pathElements[index2];
            Object mapValue = map.get(key2);
            for (nextIndex = index2 + 1; mapValue == null && nextIndex != pathElements.length; ++nextIndex) {
                key2 = key2 + "." + pathElements[nextIndex];
                mapValue = map.get(key2);
            }
            return XContentMapValues.extractValue(pathElements, nextIndex, mapValue);
        }
        if (currentValue instanceof List) {
            List valueList = (List)currentValue;
            ArrayList<Object> newList = new ArrayList<Object>(valueList.size());
            for (Object o : valueList) {
                Object listValue = XContentMapValues.extractValue(pathElements, index2, o);
                if (listValue == null) continue;
                newList.add(listValue);
            }
            return newList;
        }
        return null;
    }

    public static Map<String, Object> filter(Map<String, Object> map, String[] includes, String[] excludes) {
        HashMap<String, Object> result2 = Maps.newHashMap();
        XContentMapValues.filter(map, result2, includes, excludes, new StringBuilder());
        return result2;
    }

    private static void filter(Map<String, Object> map, Map<String, Object> into, String[] includes, String[] excludes, StringBuilder sb) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key2 = entry.getKey();
            int mark2 = sb.length();
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(key2);
            String path2 = sb.toString();
            boolean excluded = false;
            for (String exclude : excludes) {
                if (!Regex.simpleMatch(exclude, path2)) continue;
                excluded = true;
                break;
            }
            if (excluded) {
                sb.setLength(mark2);
                continue;
            }
            if (includes.length > 0) {
                boolean atLeastOnOneIncludeMatched = false;
                for (String include2 : includes) {
                    if (!include2.startsWith(path2) && !Regex.simpleMatch(include2, path2)) continue;
                    atLeastOnOneIncludeMatched = true;
                    break;
                }
                if (!atLeastOnOneIncludeMatched) {
                    sb.setLength(mark2);
                    continue;
                }
            }
            if (entry.getValue() instanceof Map) {
                HashMap<String, Object> innerInto = Maps.newHashMap();
                XContentMapValues.filter((Map)entry.getValue(), innerInto, includes, excludes, sb);
                if (!innerInto.isEmpty()) {
                    into.put(entry.getKey(), innerInto);
                }
            } else if (entry.getValue() instanceof List) {
                List list2 = (List)entry.getValue();
                ArrayList<Object> innerInto = new ArrayList<Object>(list2.size());
                XContentMapValues.filter(list2, innerInto, includes, excludes, sb);
                into.put(entry.getKey(), innerInto);
            } else {
                into.put(entry.getKey(), entry.getValue());
            }
            sb.setLength(mark2);
        }
    }

    private static void filter(List<Object> from, List<Object> to, String[] includes, String[] excludes, StringBuilder sb) {
        for (Object o : from) {
            Cloneable innerInto;
            if (o instanceof Map) {
                innerInto = Maps.newHashMap();
                XContentMapValues.filter((Map)o, innerInto, includes, excludes, sb);
                if (innerInto.isEmpty()) continue;
                to.add(innerInto);
                continue;
            }
            if (o instanceof List) {
                innerInto = new ArrayList();
                XContentMapValues.filter((List)o, (List<Object>)((Object)innerInto), includes, excludes, sb);
                continue;
            }
            to.add(o);
        }
    }

    public static boolean isObject(Object node) {
        return node instanceof Map;
    }

    public static boolean isArray(Object node) {
        return node instanceof List;
    }

    public static String nodeStringValue(Object node, String defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return node.toString();
    }

    public static float nodeFloatValue(Object node, float defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeFloatValue(node);
    }

    public static float nodeFloatValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).floatValue();
        }
        return Float.parseFloat(node.toString());
    }

    public static double nodeDoubleValue(Object node, double defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeDoubleValue(node);
    }

    public static double nodeDoubleValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).doubleValue();
        }
        return Double.parseDouble(node.toString());
    }

    public static int nodeIntegerValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).intValue();
        }
        return Integer.parseInt(node.toString());
    }

    public static int nodeIntegerValue(Object node, int defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        if (node instanceof Number) {
            return ((Number)node).intValue();
        }
        return Integer.parseInt(node.toString());
    }

    public static short nodeShortValue(Object node, short defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeShortValue(node);
    }

    public static short nodeShortValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).shortValue();
        }
        return Short.parseShort(node.toString());
    }

    public static byte nodeByteValue(Object node, byte defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeByteValue(node);
    }

    public static byte nodeByteValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).byteValue();
        }
        return Byte.parseByte(node.toString());
    }

    public static long nodeLongValue(Object node, long defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeLongValue(node);
    }

    public static long nodeLongValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).longValue();
        }
        return Long.parseLong(node.toString());
    }

    public static boolean nodeBooleanValue(Object node, boolean defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeBooleanValue(node);
    }

    public static boolean nodeBooleanValue(Object node) {
        if (node instanceof Boolean) {
            return (Boolean)node;
        }
        if (node instanceof Number) {
            return ((Number)node).intValue() != 0;
        }
        String value2 = node.toString();
        return !value2.equals("false") && !value2.equals("0") && !value2.equals("off");
    }

    public static TimeValue nodeTimeValue(Object node, TimeValue defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeTimeValue(node);
    }

    public static TimeValue nodeTimeValue(Object node) {
        if (node instanceof Number) {
            return TimeValue.timeValueMillis(((Number)node).longValue());
        }
        return TimeValue.parseTimeValue(node.toString(), null);
    }
}

