/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent.jsr166e;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.util.concurrent.jsr166e.ConcurrentHashMapV8;
import org.elasticsearch.common.util.concurrent.jsr166e.LongAdder;

public class LongAdderTable<K>
implements Serializable {
    private static final long serialVersionUID = 7249369246863182397L;
    private final ConcurrentHashMapV8<K, LongAdder> map = new ConcurrentHashMapV8();
    private static final CreateAdder createAdder = new CreateAdder();

    public LongAdder install(K key2) {
        return this.map.computeIfAbsent(key2, createAdder);
    }

    public void add(K key2, long x) {
        this.map.computeIfAbsent(key2, createAdder).add(x);
    }

    public void increment(K key2) {
        this.add(key2, 1L);
    }

    public void decrement(K key2) {
        this.add(key2, -1L);
    }

    public long sum(K key2) {
        LongAdder a = this.map.get(key2);
        return a == null ? 0L : a.sum();
    }

    public void reset(K key2) {
        LongAdder a = this.map.get(key2);
        if (a != null) {
            a.reset();
        }
    }

    public long sumThenReset(K key2) {
        LongAdder a = this.map.get(key2);
        return a == null ? 0L : a.sumThenReset();
    }

    public long sumAll() {
        long sum2 = 0L;
        for (LongAdder a : this.map.values()) {
            sum2 += a.sum();
        }
        return sum2;
    }

    public void resetAll() {
        for (LongAdder a : this.map.values()) {
            a.reset();
        }
    }

    public long sumThenResetAll() {
        long sum2 = 0L;
        for (LongAdder a : this.map.values()) {
            sum2 += a.sumThenReset();
        }
        return sum2;
    }

    public void remove(K key2) {
        this.map.remove(key2);
    }

    public void removeAll() {
        this.map.clear();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Set<Map.Entry<K, LongAdder>> entrySet() {
        return this.map.entrySet();
    }

    static final class CreateAdder
    implements ConcurrentHashMapV8.Fun<Object, LongAdder> {
        CreateAdder() {
        }

        @Override
        public LongAdder apply(Object unused2) {
            return new LongAdder();
        }
    }
}

