/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.unit;

public enum ByteSizeUnit {
    BYTES{

        @Override
        public long toBytes(long size2) {
            return size2;
        }

        @Override
        public long toKB(long size2) {
            return size2 / 1024L;
        }

        @Override
        public long toMB(long size2) {
            return size2 / 0x100000L;
        }

        @Override
        public long toGB(long size2) {
            return size2 / 0x40000000L;
        }
    }
    ,
    KB{

        @Override
        public long toBytes(long size2) {
            return 2.x(size2, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toKB(long size2) {
            return size2;
        }

        @Override
        public long toMB(long size2) {
            return size2 / 1024L;
        }

        @Override
        public long toGB(long size2) {
            return size2 / 0x100000L;
        }
    }
    ,
    MB{

        @Override
        public long toBytes(long size2) {
            return 3.x(size2, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toKB(long size2) {
            return 3.x(size2, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toMB(long size2) {
            return size2;
        }

        @Override
        public long toGB(long size2) {
            return size2 / 1024L;
        }
    }
    ,
    GB{

        @Override
        public long toBytes(long size2) {
            return 4.x(size2, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toKB(long size2) {
            return 4.x(size2, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toMB(long size2) {
            return 4.x(size2, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toGB(long size2) {
            return size2;
        }
    };

    static final long C0 = 1L;
    static final long C1 = 1024L;
    static final long C2 = 0x100000L;
    static final long C3 = 0x40000000L;
    static final long MAX = Long.MAX_VALUE;

    static long x(long d, long m, long over) {
        if (d > over) {
            return Long.MAX_VALUE;
        }
        if (d < -over) {
            return Long.MIN_VALUE;
        }
        return d * m;
    }

    public long toBytes(long size2) {
        throw new AbstractMethodError();
    }

    public long toKB(long size2) {
        throw new AbstractMethodError();
    }

    public long toMB(long size2) {
        throw new AbstractMethodError();
    }

    public long toGB(long size2) {
        throw new AbstractMethodError();
    }
}

