/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.trove.map.hash;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import org.elasticsearch.common.trove.TFloatCollection;
import org.elasticsearch.common.trove.TIntCollection;
import org.elasticsearch.common.trove.function.TIntFunction;
import org.elasticsearch.common.trove.impl.HashFunctions;
import org.elasticsearch.common.trove.impl.hash.TFloatIntHash;
import org.elasticsearch.common.trove.impl.hash.THashPrimitiveIterator;
import org.elasticsearch.common.trove.impl.hash.TPrimitiveHash;
import org.elasticsearch.common.trove.iterator.TFloatIntIterator;
import org.elasticsearch.common.trove.iterator.TFloatIterator;
import org.elasticsearch.common.trove.iterator.TIntIterator;
import org.elasticsearch.common.trove.map.TFloatIntMap;
import org.elasticsearch.common.trove.procedure.TFloatIntProcedure;
import org.elasticsearch.common.trove.procedure.TFloatProcedure;
import org.elasticsearch.common.trove.procedure.TIntProcedure;
import org.elasticsearch.common.trove.set.TFloatSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFloatIntHashMap
extends TFloatIntHash
implements TFloatIntMap,
Externalizable {
    static final long serialVersionUID = 1L;
    protected transient int[] _values;

    public TFloatIntHashMap() {
    }

    public TFloatIntHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TFloatIntHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TFloatIntHashMap(int initialCapacity, float loadFactor, float noEntryKey, int noEntryValue) {
        super(initialCapacity, loadFactor, noEntryKey, noEntryValue);
    }

    public TFloatIntHashMap(float[] keys2, int[] values2) {
        super(Math.max(keys2.length, values2.length));
        int size2 = Math.min(keys2.length, values2.length);
        for (int i2 = 0; i2 < size2; ++i2) {
            this.put(keys2[i2], values2[i2]);
        }
    }

    public TFloatIntHashMap(TFloatIntMap map) {
        super(map.size());
        if (map instanceof TFloatIntHashMap) {
            TFloatIntHashMap hashmap = (TFloatIntHashMap)map;
            this._loadFactor = hashmap._loadFactor;
            this.no_entry_key = hashmap.no_entry_key;
            this.no_entry_value = hashmap.no_entry_value;
            if (this.no_entry_key != 0.0f) {
                Arrays.fill(this._set, this.no_entry_key);
            }
            if (this.no_entry_value != 0) {
                Arrays.fill(this._values, this.no_entry_value);
            }
            this.setUp((int)Math.ceil(10.0f / this._loadFactor));
        }
        this.putAll(map);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new int[capacity];
        return capacity;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        float[] oldKeys = this._set;
        int[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new float[newCapacity];
        this._values = new int[newCapacity];
        this._states = new byte[newCapacity];
        int i2 = oldCapacity;
        while (i2-- > 0) {
            if (oldStates[i2] != 1) continue;
            float o = oldKeys[i2];
            int index2 = this.insertKey(o);
            this._values[index2] = oldVals[i2];
        }
    }

    @Override
    public int put(float key2, int value2) {
        int index2 = this.insertKey(key2);
        return this.doPut(key2, value2, index2);
    }

    @Override
    public int putIfAbsent(float key2, int value2) {
        int index2 = this.insertKey(key2);
        if (index2 < 0) {
            return this._values[-index2 - 1];
        }
        return this.doPut(key2, value2, index2);
    }

    private int doPut(float key2, int value2, int index2) {
        int previous = this.no_entry_value;
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
            isNewMapping = false;
        }
        this._values[index2] = value2;
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return previous;
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Integer> map) {
        this.ensureCapacity(map.size());
        for (Map.Entry<? extends Float, ? extends Integer> entry : map.entrySet()) {
            this.put(entry.getKey().floatValue(), entry.getValue());
        }
    }

    @Override
    public void putAll(TFloatIntMap map) {
        this.ensureCapacity(map.size());
        TFloatIntIterator iter = map.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.put(iter.key(), iter.value());
        }
    }

    @Override
    public int get(float key2) {
        int index2 = this.index(key2);
        return index2 < 0 ? this.no_entry_value : this._values[index2];
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this._set, 0, this._set.length, this.no_entry_key);
        Arrays.fill(this._values, 0, this._values.length, this.no_entry_value);
        Arrays.fill(this._states, 0, this._states.length, (byte)0);
    }

    @Override
    public boolean isEmpty() {
        return 0 == this._size;
    }

    @Override
    public int remove(float key2) {
        int prev = this.no_entry_value;
        int index2 = this.index(key2);
        if (index2 >= 0) {
            prev = this._values[index2];
            this.removeAt(index2);
        }
        return prev;
    }

    @Override
    protected void removeAt(int index2) {
        this._values[index2] = this.no_entry_value;
        super.removeAt(index2);
    }

    @Override
    public TFloatSet keySet() {
        return new TKeyView();
    }

    @Override
    public float[] keys() {
        float[] keys2 = new float[this.size()];
        float[] k = this._set;
        byte[] states = this._states;
        int i2 = k.length;
        int j = 0;
        while (i2-- > 0) {
            if (states[i2] != 1) continue;
            keys2[j++] = k[i2];
        }
        return keys2;
    }

    @Override
    public float[] keys(float[] array) {
        int size2 = this.size();
        if (array.length < size2) {
            array = new float[size2];
        }
        float[] keys2 = this._set;
        byte[] states = this._states;
        int i2 = keys2.length;
        int j = 0;
        while (i2-- > 0) {
            if (states[i2] != 1) continue;
            array[j++] = keys2[i2];
        }
        return array;
    }

    @Override
    public TIntCollection valueCollection() {
        return new TValueView();
    }

    @Override
    public int[] values() {
        int[] vals = new int[this.size()];
        int[] v = this._values;
        byte[] states = this._states;
        int i2 = v.length;
        int j = 0;
        while (i2-- > 0) {
            if (states[i2] != 1) continue;
            vals[j++] = v[i2];
        }
        return vals;
    }

    @Override
    public int[] values(int[] array) {
        int size2 = this.size();
        if (array.length < size2) {
            array = new int[size2];
        }
        int[] v = this._values;
        byte[] states = this._states;
        int i2 = v.length;
        int j = 0;
        while (i2-- > 0) {
            if (states[i2] != 1) continue;
            array[j++] = v[i2];
        }
        return array;
    }

    @Override
    public boolean containsValue(int val) {
        byte[] states = this._states;
        int[] vals = this._values;
        int i2 = vals.length;
        while (i2-- > 0) {
            if (states[i2] != 1 || val != vals[i2]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(float key2) {
        return this.contains(key2);
    }

    @Override
    public TFloatIntIterator iterator() {
        return new TFloatIntHashIterator(this);
    }

    @Override
    public boolean forEachKey(TFloatProcedure procedure) {
        return this.forEach(procedure);
    }

    @Override
    public boolean forEachValue(TIntProcedure procedure) {
        byte[] states = this._states;
        int[] values2 = this._values;
        int i2 = values2.length;
        while (i2-- > 0) {
            if (states[i2] != 1 || procedure.execute(values2[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachEntry(TFloatIntProcedure procedure) {
        byte[] states = this._states;
        float[] keys2 = this._set;
        int[] values2 = this._values;
        int i2 = keys2.length;
        while (i2-- > 0) {
            if (states[i2] != 1 || procedure.execute(keys2[i2], values2[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void transformValues(TIntFunction function) {
        byte[] states = this._states;
        int[] values2 = this._values;
        int i2 = values2.length;
        while (i2-- > 0) {
            if (states[i2] != 1) continue;
            values2[i2] = function.execute(values2[i2]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainEntries(TFloatIntProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        float[] keys2 = this._set;
        int[] values2 = this._values;
        this.tempDisableAutoCompaction();
        try {
            int i2 = keys2.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(keys2[i2], values2[i2])) continue;
                this.removeAt(i2);
                modified = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return modified;
    }

    @Override
    public boolean increment(float key2) {
        return this.adjustValue(key2, 1);
    }

    @Override
    public boolean adjustValue(float key2, int amount) {
        int index2 = this.index(key2);
        if (index2 < 0) {
            return false;
        }
        int n = index2;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    @Override
    public int adjustOrPutValue(float key2, int adjust_amount, int put_amount) {
        boolean isNewMapping;
        int newValue;
        int index2 = this.insertKey(key2);
        if (index2 < 0) {
            int n = index2 = -index2 - 1;
            int n2 = this._values[n] + adjust_amount;
            this._values[n] = n2;
            newValue = n2;
            isNewMapping = false;
        } else {
            newValue = this._values[index2] = put_amount;
            isNewMapping = true;
        }
        byte previousState = this._states[index2];
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return newValue;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TFloatIntMap)) {
            return false;
        }
        TFloatIntMap that = (TFloatIntMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        int[] values2 = this._values;
        byte[] states = this._states;
        int this_no_entry_value = this.getNoEntryValue();
        int that_no_entry_value = that.getNoEntryValue();
        int i2 = values2.length;
        while (i2-- > 0) {
            float key2;
            int that_value;
            int this_value;
            if (states[i2] != 1 || (this_value = values2[i2]) == (that_value = that.get(key2 = this._set[i2])) || this_value == this_no_entry_value || that_value == that_no_entry_value) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashcode = 0;
        byte[] states = this._states;
        int i2 = this._values.length;
        while (i2-- > 0) {
            if (states[i2] != 1) continue;
            hashcode += HashFunctions.hash(this._set[i2]) ^ HashFunctions.hash(this._values[i2]);
        }
        return hashcode;
    }

    public String toString() {
        final StringBuilder buf = new StringBuilder("{");
        this.forEachEntry(new TFloatIntProcedure(){
            private boolean first = true;

            public boolean execute(float key2, int value2) {
                if (this.first) {
                    this.first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(key2);
                buf.append("=");
                buf.append(value2);
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        super.writeExternal(out);
        out.writeInt(this._size);
        int i2 = this._states.length;
        while (i2-- > 0) {
            if (this._states[i2] != 1) continue;
            out.writeFloat(this._set[i2]);
            out.writeInt(this._values[i2]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        super.readExternal(in);
        int size2 = in.readInt();
        this.setUp(size2);
        while (size2-- > 0) {
            float key2 = in.readFloat();
            int val = in.readInt();
            this.put(key2, val);
        }
    }

    class TFloatIntHashIterator
    extends THashPrimitiveIterator
    implements TFloatIntIterator {
        TFloatIntHashIterator(TFloatIntHashMap map) {
            super(map);
        }

        public void advance() {
            this.moveToNextIndex();
        }

        public float key() {
            return TFloatIntHashMap.this._set[this._index];
        }

        public int value() {
            return TFloatIntHashMap.this._values[this._index];
        }

        public int setValue(int val) {
            int old = this.value();
            TFloatIntHashMap.this._values[this._index] = val;
            return old;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TFloatIntHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    class TFloatIntValueHashIterator
    extends THashPrimitiveIterator
    implements TIntIterator {
        TFloatIntValueHashIterator(TPrimitiveHash hash2) {
            super(hash2);
        }

        public int next() {
            this.moveToNextIndex();
            return TFloatIntHashMap.this._values[this._index];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TFloatIntHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    class TFloatIntKeyHashIterator
    extends THashPrimitiveIterator
    implements TFloatIterator {
        TFloatIntKeyHashIterator(TPrimitiveHash hash2) {
            super(hash2);
        }

        public float next() {
            this.moveToNextIndex();
            return TFloatIntHashMap.this._set[this._index];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TFloatIntHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TValueView
    implements TIntCollection {
        protected TValueView() {
        }

        @Override
        public TIntIterator iterator() {
            return new TFloatIntValueHashIterator(TFloatIntHashMap.this);
        }

        @Override
        public int getNoEntryValue() {
            return TFloatIntHashMap.this.no_entry_value;
        }

        @Override
        public int size() {
            return TFloatIntHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return 0 == TFloatIntHashMap.this._size;
        }

        @Override
        public boolean contains(int entry) {
            return TFloatIntHashMap.this.containsValue(entry);
        }

        @Override
        public int[] toArray() {
            return TFloatIntHashMap.this.values();
        }

        @Override
        public int[] toArray(int[] dest) {
            return TFloatIntHashMap.this.values(dest);
        }

        @Override
        public boolean add(int entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(int entry) {
            int[] values2 = TFloatIntHashMap.this._values;
            float[] set = TFloatIntHashMap.this._set;
            int i2 = values2.length;
            while (i2-- > 0) {
                if (set[i2] == 0.0f || set[i2] == 2.0f || entry != values2[i2]) continue;
                TFloatIntHashMap.this.removeAt(i2);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Integer) {
                    int ele = (Integer)element;
                    if (TFloatIntHashMap.this.containsValue(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TIntCollection collection) {
            TIntIterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (TFloatIntHashMap.this.containsValue(iter.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(int[] array) {
            for (int element : array) {
                if (TFloatIntHashMap.this.containsValue(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Integer> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TIntCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TIntIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(TIntCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TIntIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(int[] array) {
            boolean changed = false;
            Arrays.sort(array);
            int[] values2 = TFloatIntHashMap.this._values;
            byte[] states = TFloatIntHashMap.this._states;
            int i2 = values2.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || Arrays.binarySearch(array, values2[i2]) >= 0) continue;
                TFloatIntHashMap.this.removeAt(i2);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                int c;
                if (!(element instanceof Integer) || !this.remove(c = ((Integer)element).intValue())) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(TIntCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            TIntIterator iter = collection.iterator();
            while (iter.hasNext()) {
                int element = iter.next();
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(int[] array) {
            boolean changed = false;
            int i2 = array.length;
            while (i2-- > 0) {
                if (!this.remove(array[i2])) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            TFloatIntHashMap.this.clear();
        }

        @Override
        public boolean forEach(TIntProcedure procedure) {
            return TFloatIntHashMap.this.forEachValue(procedure);
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TFloatIntHashMap.this.forEachValue(new TIntProcedure(){
                private boolean first = true;

                public boolean execute(int value2) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(value2);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TKeyView
    implements TFloatSet {
        protected TKeyView() {
        }

        @Override
        public TFloatIterator iterator() {
            return new TFloatIntKeyHashIterator(TFloatIntHashMap.this);
        }

        @Override
        public float getNoEntryValue() {
            return TFloatIntHashMap.this.no_entry_key;
        }

        @Override
        public int size() {
            return TFloatIntHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return 0 == TFloatIntHashMap.this._size;
        }

        @Override
        public boolean contains(float entry) {
            return TFloatIntHashMap.this.contains(entry);
        }

        @Override
        public float[] toArray() {
            return TFloatIntHashMap.this.keys();
        }

        @Override
        public float[] toArray(float[] dest) {
            return TFloatIntHashMap.this.keys(dest);
        }

        @Override
        public boolean add(float entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(float entry) {
            return TFloatIntHashMap.this.no_entry_value != TFloatIntHashMap.this.remove(entry);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Float) {
                    float ele = ((Float)element).floatValue();
                    if (TFloatIntHashMap.this.containsKey(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TFloatCollection collection) {
            TFloatIterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (TFloatIntHashMap.this.containsKey(iter.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(float[] array) {
            for (float element : array) {
                if (TFloatIntHashMap.this.contains(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Float> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TFloatCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(float[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TFloatIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(Float.valueOf(iter.next()))) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(TFloatCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TFloatIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(float[] array) {
            boolean changed = false;
            Arrays.sort(array);
            float[] set = TFloatIntHashMap.this._set;
            byte[] states = TFloatIntHashMap.this._states;
            int i2 = set.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || Arrays.binarySearch(array, set[i2]) >= 0) continue;
                TFloatIntHashMap.this.removeAt(i2);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                float c;
                if (!(element instanceof Float) || !this.remove(c = ((Float)element).floatValue())) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(TFloatCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            TFloatIterator iter = collection.iterator();
            while (iter.hasNext()) {
                float element = iter.next();
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(float[] array) {
            boolean changed = false;
            int i2 = array.length;
            while (i2-- > 0) {
                if (!this.remove(array[i2])) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            TFloatIntHashMap.this.clear();
        }

        @Override
        public boolean forEach(TFloatProcedure procedure) {
            return TFloatIntHashMap.this.forEachKey(procedure);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof TFloatSet)) {
                return false;
            }
            TFloatSet that = (TFloatSet)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i2 = TFloatIntHashMap.this._states.length;
            while (i2-- > 0) {
                if (TFloatIntHashMap.this._states[i2] != 1 || that.contains(TFloatIntHashMap.this._set[i2])) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hashcode = 0;
            int i2 = TFloatIntHashMap.this._states.length;
            while (i2-- > 0) {
                if (TFloatIntHashMap.this._states[i2] != 1) continue;
                hashcode += HashFunctions.hash(TFloatIntHashMap.this._set[i2]);
            }
            return hashcode;
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TFloatIntHashMap.this.forEachKey(new TFloatProcedure(){
                private boolean first = true;

                public boolean execute(float key2) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(key2);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }
    }
}

