/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.trove.list.array;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.Random;
import org.elasticsearch.common.trove.TShortCollection;
import org.elasticsearch.common.trove.function.TShortFunction;
import org.elasticsearch.common.trove.impl.HashFunctions;
import org.elasticsearch.common.trove.iterator.TShortIterator;
import org.elasticsearch.common.trove.list.TShortList;
import org.elasticsearch.common.trove.procedure.TShortProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TShortArrayList
implements TShortList,
Externalizable {
    static final long serialVersionUID = 1L;
    protected short[] _data;
    protected int _pos;
    protected static final int DEFAULT_CAPACITY = 10;
    protected short no_entry_value;

    public TShortArrayList() {
        this(10, 0);
    }

    public TShortArrayList(int capacity) {
        this(capacity, 0);
    }

    public TShortArrayList(int capacity, short no_entry_value) {
        this._data = new short[capacity];
        this._pos = 0;
        this.no_entry_value = no_entry_value;
    }

    public TShortArrayList(TShortCollection collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public TShortArrayList(short[] values2) {
        this(values2.length);
        this.add(values2);
    }

    protected TShortArrayList(short[] values2, short no_entry_value, boolean wrap2) {
        if (!wrap2) {
            throw new IllegalStateException("Wrong call");
        }
        if (values2 == null) {
            throw new IllegalArgumentException("values can not be null");
        }
        this._data = values2;
        this._pos = values2.length;
        this.no_entry_value = no_entry_value;
    }

    public static TShortArrayList wrap(short[] values2) {
        return TShortArrayList.wrap(values2, (short)0);
    }

    public static TShortArrayList wrap(short[] values2, short no_entry_value) {
        return new TShortArrayList(values2, no_entry_value, true){

            public void ensureCapacity(int capacity) {
                if (capacity > this._data.length) {
                    throw new IllegalStateException("Can not grow ArrayList wrapped external array");
                }
            }
        };
    }

    @Override
    public short getNoEntryValue() {
        return this.no_entry_value;
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this._data.length) {
            int newCap = Math.max(this._data.length << 1, capacity);
            short[] tmp = new short[newCap];
            System.arraycopy(this._data, 0, tmp, 0, this._data.length);
            this._data = tmp;
        }
    }

    @Override
    public int size() {
        return this._pos;
    }

    @Override
    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data.length > this.size()) {
            short[] tmp = new short[this.size()];
            this.toArray(tmp, 0, tmp.length);
            this._data = tmp;
        }
    }

    @Override
    public boolean add(short val) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = val;
        return true;
    }

    @Override
    public void add(short[] vals) {
        this.add(vals, 0, vals.length);
    }

    @Override
    public void add(short[] vals, int offset2, int length2) {
        this.ensureCapacity(this._pos + length2);
        System.arraycopy(vals, offset2, this._data, this._pos, length2);
        this._pos += length2;
    }

    @Override
    public void insert(int offset2, short value2) {
        if (offset2 == this._pos) {
            this.add(value2);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, offset2, this._data, offset2 + 1, this._pos - offset2);
        this._data[offset2] = value2;
        ++this._pos;
    }

    @Override
    public void insert(int offset2, short[] values2) {
        this.insert(offset2, values2, 0, values2.length);
    }

    @Override
    public void insert(int offset2, short[] values2, int valOffset, int len) {
        if (offset2 == this._pos) {
            this.add(values2, valOffset, len);
            return;
        }
        this.ensureCapacity(this._pos + len);
        System.arraycopy(this._data, offset2, this._data, offset2 + len, this._pos - offset2);
        System.arraycopy(values2, valOffset, this._data, offset2, len);
        this._pos += len;
    }

    @Override
    public short get(int offset2) {
        if (offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        return this._data[offset2];
    }

    public short getQuick(int offset2) {
        return this._data[offset2];
    }

    @Override
    public short set(int offset2, short val) {
        if (offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        short prev_val = this._data[offset2];
        this._data[offset2] = val;
        return prev_val;
    }

    @Override
    public short replace(int offset2, short val) {
        if (offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        short old = this._data[offset2];
        this._data[offset2] = val;
        return old;
    }

    @Override
    public void set(int offset2, short[] values2) {
        this.set(offset2, values2, 0, values2.length);
    }

    @Override
    public void set(int offset2, short[] values2, int valOffset, int length2) {
        if (offset2 < 0 || offset2 + length2 > this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        System.arraycopy(values2, valOffset, this._data, offset2, length2);
    }

    public void setQuick(int offset2, short val) {
        this._data[offset2] = val;
    }

    @Override
    public void clear() {
        this.clear(10);
    }

    public void clear(int capacity) {
        this._data = new short[capacity];
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
        Arrays.fill(this._data, this.no_entry_value);
    }

    public void resetQuick() {
        this._pos = 0;
    }

    @Override
    public boolean remove(short value2) {
        for (int index2 = 0; index2 < this._pos; ++index2) {
            if (value2 != this._data[index2]) continue;
            this.remove(index2, 1);
            return true;
        }
        return false;
    }

    @Override
    public short removeAt(int offset2) {
        short old = this.get(offset2);
        this.remove(offset2, 1);
        return old;
    }

    @Override
    public void remove(int offset2, int length2) {
        if (length2 == 0) {
            return;
        }
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        if (offset2 == 0) {
            System.arraycopy(this._data, length2, this._data, 0, this._pos - length2);
        } else if (this._pos - length2 != offset2) {
            System.arraycopy(this._data, offset2 + length2, this._data, offset2, this._pos - (offset2 + length2));
        }
        this._pos -= length2;
    }

    @Override
    public TShortIterator iterator() {
        return new TShortArrayIterator(0);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object element : collection) {
            if (element instanceof Short) {
                short c = (Short)element;
                if (this.contains(c)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(TShortCollection collection) {
        if (this == collection) {
            return true;
        }
        TShortIterator iter = collection.iterator();
        while (iter.hasNext()) {
            short element = iter.next();
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(short[] array) {
        int i2 = array.length;
        while (i2-- > 0) {
            if (this.contains(array[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Short> collection) {
        boolean changed = false;
        for (Short s2 : collection) {
            short e = s2;
            if (!this.add(e)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(TShortCollection collection) {
        boolean changed = false;
        TShortIterator iter = collection.iterator();
        while (iter.hasNext()) {
            short element = iter.next();
            if (!this.add(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(short[] array) {
        boolean changed = false;
        for (short element : array) {
            if (!this.add(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean modified = false;
        TShortIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (collection.contains(iter.next())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(TShortCollection collection) {
        if (this == collection) {
            return false;
        }
        boolean modified = false;
        TShortIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (collection.contains(iter.next())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(short[] array) {
        boolean changed = false;
        Arrays.sort(array);
        short[] data2 = this._data;
        int i2 = this._pos;
        while (i2-- > 0) {
            if (Arrays.binarySearch(array, data2[i2]) >= 0) continue;
            this.remove(i2, 1);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object element : collection) {
            short c;
            if (!(element instanceof Short) || !this.remove(c = ((Short)element).shortValue())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(TShortCollection collection) {
        if (collection == this) {
            this.clear();
            return true;
        }
        boolean changed = false;
        TShortIterator iter = collection.iterator();
        while (iter.hasNext()) {
            short element = iter.next();
            if (!this.remove(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(short[] array) {
        boolean changed = false;
        int i2 = array.length;
        while (i2-- > 0) {
            if (!this.remove(array[i2])) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void transformValues(TShortFunction function) {
        int i2 = this._pos;
        while (i2-- > 0) {
            this._data[i2] = function.execute(this._data[i2]);
        }
    }

    @Override
    public void reverse() {
        this.reverse(0, this._pos);
    }

    @Override
    public void reverse(int from, int to) {
        if (from == to) {
            return;
        }
        if (from > to) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int i2 = from;
        for (int j = to - 1; i2 < j; ++i2, --j) {
            this.swap(i2, j);
        }
    }

    @Override
    public void shuffle(Random rand2) {
        int i2 = this._pos;
        while (i2-- > 1) {
            this.swap(i2, rand2.nextInt(i2));
        }
    }

    private void swap(int i2, int j) {
        short tmp = this._data[i2];
        this._data[i2] = this._data[j];
        this._data[j] = tmp;
    }

    @Override
    public TShortList subList(int begin2, int end2) {
        if (end2 < begin2) {
            throw new IllegalArgumentException("end index " + end2 + " greater than begin index " + begin2);
        }
        if (begin2 < 0) {
            throw new IndexOutOfBoundsException("begin index can not be < 0");
        }
        if (end2 > this._data.length) {
            throw new IndexOutOfBoundsException("end index < " + this._data.length);
        }
        TShortArrayList list2 = new TShortArrayList(end2 - begin2);
        for (int i2 = begin2; i2 < end2; ++i2) {
            list2.add(this._data[i2]);
        }
        return list2;
    }

    @Override
    public short[] toArray() {
        return this.toArray(0, this._pos);
    }

    @Override
    public short[] toArray(int offset2, int len) {
        short[] rv = new short[len];
        this.toArray(rv, offset2, len);
        return rv;
    }

    @Override
    public short[] toArray(short[] dest) {
        int len = dest.length;
        if (dest.length > this._pos) {
            len = this._pos;
            dest[len] = this.no_entry_value;
        }
        this.toArray(dest, 0, len);
        return dest;
    }

    @Override
    public short[] toArray(short[] dest, int offset2, int len) {
        if (len == 0) {
            return dest;
        }
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        System.arraycopy(this._data, offset2, dest, 0, len);
        return dest;
    }

    @Override
    public short[] toArray(short[] dest, int source_pos, int dest_pos, int len) {
        if (len == 0) {
            return dest;
        }
        if (source_pos < 0 || source_pos >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(source_pos);
        }
        System.arraycopy(this._data, source_pos, dest, dest_pos, len);
        return dest;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TShortArrayList) {
            TShortArrayList that = (TShortArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i2 = this._pos;
            while (i2-- > 0) {
                if (this._data[i2] == that._data[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i2 = this._pos;
        while (i2-- > 0) {
            h += HashFunctions.hash(this._data[i2]);
        }
        return h;
    }

    @Override
    public boolean forEach(TShortProcedure procedure) {
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (procedure.execute(this._data[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachDescending(TShortProcedure procedure) {
        int i2 = this._pos;
        while (i2-- > 0) {
            if (procedure.execute(this._data[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void sort() {
        Arrays.sort(this._data, 0, this._pos);
    }

    @Override
    public void sort(int fromIndex, int toIndex) {
        Arrays.sort(this._data, fromIndex, toIndex);
    }

    @Override
    public void fill(short val) {
        Arrays.fill(this._data, 0, this._pos, val);
    }

    @Override
    public void fill(int fromIndex, int toIndex, short val) {
        if (toIndex > this._pos) {
            this.ensureCapacity(toIndex);
            this._pos = toIndex;
        }
        Arrays.fill(this._data, fromIndex, toIndex, val);
    }

    @Override
    public int binarySearch(short value2) {
        return this.binarySearch(value2, 0, this._pos);
    }

    @Override
    public int binarySearch(short value2, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            short midVal = this._data[mid];
            if (midVal < value2) {
                low = mid + 1;
                continue;
            }
            if (midVal > value2) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public int indexOf(short value2) {
        return this.indexOf(0, value2);
    }

    @Override
    public int indexOf(int offset2, short value2) {
        for (int i2 = offset2; i2 < this._pos; ++i2) {
            if (this._data[i2] != value2) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(short value2) {
        return this.lastIndexOf(this._pos, value2);
    }

    @Override
    public int lastIndexOf(int offset2, short value2) {
        int i2 = offset2;
        while (i2-- > 0) {
            if (this._data[i2] != value2) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean contains(short value2) {
        return this.lastIndexOf(value2) >= 0;
    }

    @Override
    public TShortList grep(TShortProcedure condition) {
        TShortArrayList list2 = new TShortArrayList();
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (!condition.execute(this._data[i2])) continue;
            list2.add(this._data[i2]);
        }
        return list2;
    }

    @Override
    public TShortList inverseGrep(TShortProcedure condition) {
        TShortArrayList list2 = new TShortArrayList();
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (condition.execute(this._data[i2])) continue;
            list2.add(this._data[i2]);
        }
        return list2;
    }

    @Override
    public short max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        short max2 = Short.MIN_VALUE;
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (this._data[i2] <= max2) continue;
            max2 = this._data[i2];
        }
        return max2;
    }

    @Override
    public short min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        short min2 = Short.MAX_VALUE;
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (this._data[i2] >= min2) continue;
            min2 = this._data[i2];
        }
        return min2;
    }

    @Override
    public short sum() {
        short sum2 = 0;
        for (int i2 = 0; i2 < this._pos; ++i2) {
            sum2 = (short)(sum2 + this._data[i2]);
        }
        return sum2;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("{");
        int end2 = this._pos - 1;
        for (int i2 = 0; i2 < end2; ++i2) {
            buf.append(this._data[i2]);
            buf.append(", ");
        }
        if (this.size() > 0) {
            buf.append(this._data[this._pos - 1]);
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this._pos);
        out.writeShort(this.no_entry_value);
        int len = this._data.length;
        out.writeInt(len);
        for (int i2 = 0; i2 < len; ++i2) {
            out.writeShort(this._data[i2]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this._pos = in.readInt();
        this.no_entry_value = in.readShort();
        int len = in.readInt();
        this._data = new short[len];
        for (int i2 = 0; i2 < len; ++i2) {
            this._data[i2] = in.readShort();
        }
    }

    class TShortArrayIterator
    implements TShortIterator {
        private int cursor = 0;
        int lastRet = -1;

        TShortArrayIterator(int index2) {
            this.cursor = index2;
        }

        public boolean hasNext() {
            return this.cursor < TShortArrayList.this.size();
        }

        public short next() {
            try {
                short next = TShortArrayList.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            try {
                TShortArrayList.this.remove(this.lastRet, 1);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

