/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings.loader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;

public interface SettingsLoader {
    public Map<String, String> load(String var1) throws IOException;

    public Map<String, String> load(byte[] var1) throws IOException;

    public static class Helper {
        public static Map<String, String> loadNestedFromMap(@Nullable Map map) {
            HashMap<String, String> settings = Maps.newHashMap();
            if (map == null) {
                return settings;
            }
            StringBuilder sb = new StringBuilder();
            ArrayList<String> path2 = Lists.newArrayList();
            Helper.serializeMap(settings, sb, path2, map);
            return settings;
        }

        private static void serializeMap(Map<String, String> settings, StringBuilder sb, List<String> path2, Map<Object, Object> map) {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                if (entry.getValue() instanceof Map) {
                    path2.add((String)entry.getKey());
                    Helper.serializeMap(settings, sb, path2, (Map)entry.getValue());
                    path2.remove(path2.size() - 1);
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    path2.add((String)entry.getKey());
                    Helper.serializeList(settings, sb, path2, (List)entry.getValue());
                    path2.remove(path2.size() - 1);
                    continue;
                }
                Helper.serializeValue(settings, sb, path2, (String)entry.getKey(), entry.getValue());
            }
        }

        private static void serializeList(Map<String, String> settings, StringBuilder sb, List<String> path2, List list2) {
            int counter = 0;
            for (Object listEle : list2) {
                if (listEle instanceof Map) {
                    path2.add(Integer.toString(counter));
                    Helper.serializeMap(settings, sb, path2, (Map)listEle);
                    path2.remove(path2.size() - 1);
                } else if (listEle instanceof List) {
                    path2.add(Integer.toString(counter));
                    Helper.serializeList(settings, sb, path2, (List)listEle);
                    path2.remove(path2.size() - 1);
                } else {
                    Helper.serializeValue(settings, sb, path2, Integer.toString(counter), listEle);
                }
                ++counter;
            }
        }

        private static void serializeValue(Map<String, String> settings, StringBuilder sb, List<String> path2, String name2, Object value2) {
            if (value2 == null) {
                return;
            }
            sb.setLength(0);
            for (String pathEle : path2) {
                sb.append(pathEle).append('.');
            }
            sb.append(name2);
            settings.put(sb.toString(), value2.toString());
        }
    }
}

