/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.primitives;

import javax.annotation.CheckForNull;
import org.elasticsearch.common.base.Preconditions;

final class AndroidInteger {
    @CheckForNull
    static Integer tryParse(String string2) {
        return AndroidInteger.tryParse(string2, 10);
    }

    @CheckForNull
    static Integer tryParse(String string2, int radix) {
        boolean negative;
        Preconditions.checkNotNull(string2);
        Preconditions.checkArgument(radix >= 2, "Invalid radix %s, min radix is %s", radix, 2);
        Preconditions.checkArgument(radix <= 36, "Invalid radix %s, max radix is %s", radix, 36);
        int length2 = string2.length();
        int i2 = 0;
        if (length2 == 0) {
            return null;
        }
        boolean bl = negative = string2.charAt(i2) == '-';
        if (negative && ++i2 == length2) {
            return null;
        }
        return AndroidInteger.tryParse(string2, i2, radix, negative);
    }

    @CheckForNull
    private static Integer tryParse(String string2, int offset2, int radix, boolean negative) {
        int max2 = Integer.MIN_VALUE / radix;
        int result2 = 0;
        int length2 = string2.length();
        while (offset2 < length2) {
            int digit;
            if ((digit = Character.digit(string2.charAt(offset2++), radix)) == -1) {
                return null;
            }
            if (max2 > result2) {
                return null;
            }
            int next = result2 * radix - digit;
            if (next > result2) {
                return null;
            }
            result2 = next;
        }
        if (!negative && (result2 = -result2) < 0) {
            return null;
        }
        if (result2 > Integer.MAX_VALUE || result2 < Integer.MIN_VALUE) {
            return null;
        }
        return result2;
    }

    private AndroidInteger() {
    }
}

