/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.util.internal;

import java.util.ArrayList;
import java.util.Formatter;

public final class StringUtil {
    public static final String NEWLINE;
    private static final String EMPTY_STRING = "";

    private StringUtil() {
    }

    public static String stripControlCharacters(Object value2) {
        if (value2 == null) {
            return null;
        }
        return StringUtil.stripControlCharacters(value2.toString());
    }

    public static String stripControlCharacters(String value2) {
        int i2;
        if (value2 == null) {
            return null;
        }
        boolean hasControlChars = false;
        for (int i3 = value2.length() - 1; i3 >= 0; --i3) {
            if (!Character.isISOControl(value2.charAt(i3))) continue;
            hasControlChars = true;
            break;
        }
        if (!hasControlChars) {
            return value2;
        }
        StringBuilder buf = new StringBuilder(value2.length());
        for (i2 = 0; i2 < value2.length() && Character.isISOControl(value2.charAt(i2)); ++i2) {
        }
        boolean suppressingControlChars = false;
        while (i2 < value2.length()) {
            if (Character.isISOControl(value2.charAt(i2))) {
                suppressingControlChars = true;
            } else {
                if (suppressingControlChars) {
                    suppressingControlChars = false;
                    buf.append(' ');
                }
                buf.append(value2.charAt(i2));
            }
            ++i2;
        }
        return buf.toString();
    }

    public static String[] split(String value2, char delim) {
        int i2;
        int end2 = value2.length();
        ArrayList<String> res = new ArrayList<String>();
        int start2 = 0;
        for (i2 = 0; i2 < end2; ++i2) {
            if (value2.charAt(i2) != delim) continue;
            if (start2 == i2) {
                res.add(EMPTY_STRING);
            } else {
                res.add(value2.substring(start2, i2));
            }
            start2 = i2 + 1;
        }
        if (start2 == 0) {
            res.add(value2);
        } else if (start2 != end2) {
            res.add(value2.substring(start2, end2));
        } else {
            for (i2 = res.size() - 1; i2 >= 0 && ((String)res.get(i2)).length() == 0; --i2) {
                res.remove(i2);
            }
        }
        return res.toArray(new String[res.size()]);
    }

    static {
        String newLine;
        try {
            newLine = new Formatter().format("%n", new Object[0]).toString();
        }
        catch (Exception e) {
            newLine = "\n";
        }
        NEWLINE = newLine;
    }
}

