/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.handler.codec.http;

import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.common.netty.handler.codec.http.Cookie;
import org.elasticsearch.common.netty.handler.codec.http.CookieDateFormat;
import org.elasticsearch.common.netty.handler.codec.http.DefaultCookie;

public class CookieEncoder {
    private final Set<Cookie> cookies = new TreeSet<Cookie>();
    private final boolean server;

    public CookieEncoder(boolean server) {
        this.server = server;
    }

    public void addCookie(String name2, String value2) {
        this.cookies.add(new DefaultCookie(name2, value2));
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public String encode() {
        String answer = this.server ? this.encodeServerSide() : this.encodeClientSide();
        this.cookies.clear();
        return answer;
    }

    private String encodeServerSide() {
        if (this.cookies.size() > 1) {
            throw new IllegalStateException("encode() can encode only one cookie on server mode: " + this.cookies.size() + " cookies added");
        }
        StringBuilder sb = new StringBuilder();
        for (Cookie cookie : this.cookies) {
            CookieEncoder.add(sb, cookie.getName(), cookie.getValue());
            if (cookie.getMaxAge() != Integer.MIN_VALUE) {
                if (cookie.getVersion() == 0) {
                    CookieEncoder.addUnquoted(sb, "Expires", new CookieDateFormat().format(new Date(System.currentTimeMillis() + (long)cookie.getMaxAge() * 1000L)));
                } else {
                    CookieEncoder.add(sb, "Max-Age", cookie.getMaxAge());
                }
            }
            if (cookie.getPath() != null) {
                if (cookie.getVersion() > 0) {
                    CookieEncoder.add(sb, "Path", cookie.getPath());
                } else {
                    CookieEncoder.addUnquoted(sb, "Path", cookie.getPath());
                }
            }
            if (cookie.getDomain() != null) {
                if (cookie.getVersion() > 0) {
                    CookieEncoder.add(sb, "Domain", cookie.getDomain());
                } else {
                    CookieEncoder.addUnquoted(sb, "Domain", cookie.getDomain());
                }
            }
            if (cookie.isSecure()) {
                sb.append("Secure");
                sb.append(';');
                sb.append(' ');
            }
            if (cookie.isHttpOnly()) {
                sb.append("HTTPOnly");
                sb.append(';');
                sb.append(' ');
            }
            if (cookie.getVersion() < 1) continue;
            if (cookie.getComment() != null) {
                CookieEncoder.add(sb, "Comment", cookie.getComment());
            }
            CookieEncoder.add(sb, "Version", 1);
            if (cookie.getCommentUrl() != null) {
                CookieEncoder.addQuoted(sb, "CommentURL", cookie.getCommentUrl());
            }
            if (!cookie.getPorts().isEmpty()) {
                sb.append("Port");
                sb.append('=');
                sb.append('\"');
                for (int port : cookie.getPorts()) {
                    sb.append(port);
                    sb.append(',');
                }
                sb.setCharAt(sb.length() - 1, '\"');
                sb.append(';');
                sb.append(' ');
            }
            if (!cookie.isDiscard()) continue;
            sb.append("Discard");
            sb.append(';');
            sb.append(' ');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    private String encodeClientSide() {
        StringBuilder sb = new StringBuilder();
        for (Cookie cookie : this.cookies) {
            if (cookie.getVersion() >= 1) {
                CookieEncoder.add(sb, "$Version", 1);
            }
            CookieEncoder.add(sb, cookie.getName(), cookie.getValue());
            if (cookie.getPath() != null) {
                CookieEncoder.add(sb, "$Path", cookie.getPath());
            }
            if (cookie.getDomain() != null) {
                CookieEncoder.add(sb, "$Domain", cookie.getDomain());
            }
            if (cookie.getVersion() < 1 || cookie.getPorts().isEmpty()) continue;
            sb.append('$');
            sb.append("Port");
            sb.append('=');
            sb.append('\"');
            for (int port : cookie.getPorts()) {
                sb.append(port);
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, '\"');
            sb.append(';');
            sb.append(' ');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    private static void add(StringBuilder sb, String name2, String val) {
        if (val == null) {
            CookieEncoder.addQuoted(sb, name2, "");
            return;
        }
        for (int i2 = 0; i2 < val.length(); ++i2) {
            char c = val.charAt(i2);
            switch (c) {
                case '\t': 
                case ' ': 
                case '\"': 
                case '(': 
                case ')': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    CookieEncoder.addQuoted(sb, name2, val);
                    return;
                }
            }
        }
        CookieEncoder.addUnquoted(sb, name2, val);
    }

    private static void addUnquoted(StringBuilder sb, String name2, String val) {
        sb.append(name2);
        sb.append('=');
        sb.append(val);
        sb.append(';');
        sb.append(' ');
    }

    private static void addQuoted(StringBuilder sb, String name2, String val) {
        if (val == null) {
            val = "";
        }
        sb.append(name2);
        sb.append('=');
        sb.append('\"');
        sb.append(val.replace("\\", "\\\\").replace("\"", "\\\""));
        sb.append('\"');
        sb.append(';');
        sb.append(' ');
    }

    private static void add(StringBuilder sb, String name2, int val) {
        sb.append(name2);
        sb.append('=');
        sb.append(val);
        sb.append(';');
        sb.append(' ');
    }
}

