/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel.socket.oio;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.net.SocketAddress;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelException;
import org.elasticsearch.common.netty.channel.ChannelFactory;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelSink;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.socket.oio.OioSocketChannel;

class OioAcceptedSocketChannel
extends OioSocketChannel {
    private final PushbackInputStream in;
    private final OutputStream out;

    OioAcceptedSocketChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, Socket socket2) {
        super(parent, factory, pipeline, sink, socket2);
        try {
            this.in = new PushbackInputStream(socket2.getInputStream(), 1);
        }
        catch (IOException e) {
            throw new ChannelException("Failed to obtain an InputStream.", e);
        }
        try {
            this.out = socket2.getOutputStream();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to obtain an OutputStream.", e);
        }
        Channels.fireChannelOpen(this);
        Channels.fireChannelBound(this, (SocketAddress)this.getLocalAddress());
    }

    PushbackInputStream getInputStream() {
        return this.in;
    }

    OutputStream getOutputStream() {
        return this.out;
    }
}

