/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel;

import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelException;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.CompleteChannelFuture;

public class FailedChannelFuture
extends CompleteChannelFuture {
    private final Throwable cause;

    public FailedChannelFuture(Channel channel, Throwable cause2) {
        super(channel);
        if (cause2 == null) {
            throw new NullPointerException("cause");
        }
        this.cause = cause2;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public boolean isSuccess() {
        return false;
    }

    @Deprecated
    public ChannelFuture rethrowIfFailed() throws Exception {
        if (this.cause instanceof Exception) {
            throw (Exception)this.cause;
        }
        if (this.cause instanceof Error) {
            throw (Error)this.cause;
        }
        throw new RuntimeException(this.cause);
    }

    public ChannelFuture sync() throws InterruptedException {
        this.rethrow();
        return this;
    }

    public ChannelFuture syncUninterruptibly() {
        this.rethrow();
        return this;
    }

    private void rethrow() {
        if (this.cause instanceof RuntimeException) {
            throw (RuntimeException)this.cause;
        }
        if (this.cause instanceof Error) {
            throw (Error)this.cause;
        }
        throw new ChannelException(this.cause);
    }
}

