/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.util;

import java.io.UnsupportedEncodingException;

public class StringAppender
implements CharSequence {
    private static final int DEFAULT_SIZE = 15;
    private char[] str;
    private int capacity;
    private int size = 0;
    private byte[] btr;
    private String encoding;

    public StringAppender() {
        this.capacity = 15;
        this.str = new char[15];
    }

    public StringAppender(int capacity) {
        this.capacity = capacity;
        this.str = new char[this.capacity];
    }

    public StringAppender(int capacity, String encoding2) {
        this.capacity = capacity;
        this.str = new char[this.capacity];
        this.encoding = encoding2;
    }

    public StringAppender(char c) {
        this.capacity = 15;
        char[] cArray = new char[15];
        this.str = cArray;
        cArray[0] = c;
    }

    public StringAppender(char[] s2) {
        this.str = s2;
        this.capacity = this.size = s2.length;
    }

    public StringAppender(CharSequence s2) {
        this.capacity = this.size = s2.length();
        this.str = new char[this.size];
        for (int i2 = 0; i2 < this.str.length; ++i2) {
            this.str[i2] = s2.charAt(i2);
        }
    }

    public StringAppender(String s2) {
        this.str = s2.toCharArray();
        this.capacity = this.size = this.str.length;
    }

    public StringAppender append(char[] chars2) {
        if (chars2.length > this.capacity - this.size) {
            this.grow(chars2.length);
        }
        int i2 = 0;
        while (i2 < chars2.length) {
            this.str[this.size] = chars2[i2++];
            ++this.size;
        }
        return this;
    }

    public StringAppender append(byte[] chars2) {
        if (chars2.length > this.capacity - this.size) {
            this.grow(chars2.length);
        }
        int i2 = 0;
        while (i2 < chars2.length) {
            this.str[this.size] = (char)chars2[i2++];
            ++this.size;
        }
        return this;
    }

    public StringAppender append(char[] chars2, int start2, int length2) {
        if (length2 > this.capacity - this.size) {
            this.grow(length2);
        }
        int x = start2 + length2;
        for (int i2 = start2; i2 < x; ++i2) {
            this.str[this.size++] = chars2[i2];
        }
        return this;
    }

    public StringAppender append(byte[] chars2, int start2, int length2) {
        if (length2 > this.capacity - this.size) {
            this.grow(length2);
        }
        int x = start2 + length2;
        for (int i2 = start2; i2 < x; ++i2) {
            this.str[this.size++] = (char)chars2[i2];
        }
        return this;
    }

    public StringAppender append(Object o) {
        return this.append(String.valueOf(o));
    }

    public StringAppender append(CharSequence s2) {
        if (s2.length() > this.capacity - this.size) {
            this.grow(s2.length());
        }
        int i2 = 0;
        while (i2 < s2.length()) {
            this.str[this.size] = s2.charAt(i2++);
            ++this.size;
        }
        return this;
    }

    public StringAppender append(String s2) {
        if (s2 == null) {
            return this;
        }
        int len = s2.length();
        if (len > this.capacity - this.size) {
            this.grow(len);
        }
        s2.getChars(0, len, this.str, this.size);
        this.size += len;
        return this;
    }

    public StringAppender append(char c) {
        if (this.size >= this.capacity) {
            this.grow(this.size);
        }
        this.str[this.size++] = c;
        return this;
    }

    public StringAppender append(byte b) {
        if (this.btr == null) {
            this.capacity = 15;
            this.btr = new byte[15];
        }
        if (this.size >= this.capacity) {
            this.growByte(1);
        }
        this.btr[this.size++] = b;
        return this;
    }

    public int length() {
        return this.size;
    }

    private void grow(int s2) {
        if (this.capacity == 0) {
            this.capacity = 15;
        }
        char[] newArray = new char[this.capacity += s2 * 2];
        System.arraycopy(this.str, 0, newArray, 0, this.size);
        this.str = newArray;
    }

    private void growByte(int s2) {
        byte[] newByteArray = new byte[this.capacity += s2];
        System.arraycopy(this.btr, 0, newByteArray, 0, this.size);
        this.btr = newByteArray;
    }

    public char[] getChars(int start2, int count2) {
        char[] chars2 = new char[count2];
        System.arraycopy(this.str, start2, chars2, 0, count2);
        return chars2;
    }

    public char[] toChars() {
        if (this.btr != null) {
            String s2;
            if (this.encoding == null) {
                this.encoding = System.getProperty("file.encoding");
            }
            try {
                s2 = new String(this.btr, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                s2 = new String(this.btr);
            }
            return s2.toCharArray();
        }
        char[] chars2 = new char[this.size];
        System.arraycopy(this.str, 0, chars2, 0, this.size);
        return chars2;
    }

    public String toString() {
        if (this.btr != null) {
            String s2;
            if (this.encoding == null) {
                this.encoding = System.getProperty("file.encoding");
            }
            try {
                s2 = new String(this.btr, 0, this.size, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                s2 = new String(this.btr, 0, this.size);
            }
            return s2;
        }
        if (this.size == this.capacity) {
            return new String(this.str);
        }
        return new String(this.str, 0, this.size);
    }

    public void getChars(int start2, int count2, char[] target, int offset2) {
        int delta = offset2;
        for (int i2 = start2; i2 < count2; ++i2) {
            target[delta++] = this.str[i2];
        }
    }

    public void reset() {
        this.size = 0;
    }

    public char charAt(int index2) {
        return this.str[index2];
    }

    public CharSequence substring(int start2, int end2) {
        return new String(this.str, start2, end2 - start2);
    }

    public CharSequence subSequence(int start2, int end2) {
        return this.substring(start2, end2);
    }
}

